/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.game.ClientboundPlayerChatHeaderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;

public interface OutgoingPlayerChatMessage {
    public IChatBaseComponent serverContent();

    public void sendToPlayer(EntityPlayer var1, boolean var2, ChatMessageType.a var3);

    public void sendHeadersToRemainingPlayers(PlayerList var1);

    public static OutgoingPlayerChatMessage create(PlayerChatMessage var0) {
        if (var0.signer().isSystem()) {
            return new a(var0);
        }
        return new b(var0);
    }

    public static class a
    implements OutgoingPlayerChatMessage {
        private final PlayerChatMessage message;

        public a(PlayerChatMessage var0) {
            this.message = var0;
        }

        @Override
        public IChatBaseComponent serverContent() {
            return this.message.serverContent();
        }

        @Override
        public void sendToPlayer(EntityPlayer var0, boolean var1, ChatMessageType.a var2) {
            PlayerChatMessage var3 = this.message.filter(var1);
            if (!var3.isFullyFiltered()) {
                IRegistryCustom var4 = var0.level.registryAccess();
                ChatMessageType.b var5 = var2.toNetwork(var4);
                var0.connection.send(new ClientboundPlayerChatPacket(var3, var5));
                var0.connection.addPendingMessage(var3);
            }
        }

        @Override
        public void sendHeadersToRemainingPlayers(PlayerList var0) {
        }
    }

    public static class b
    implements OutgoingPlayerChatMessage {
        private final PlayerChatMessage message;
        private final Set<EntityPlayer> playersWithFullMessage = Sets.newIdentityHashSet();

        public b(PlayerChatMessage var0) {
            this.message = var0;
        }

        @Override
        public IChatBaseComponent serverContent() {
            return this.message.serverContent();
        }

        @Override
        public void sendToPlayer(EntityPlayer var0, boolean var1, ChatMessageType.a var2) {
            PlayerChatMessage var3 = this.message.filter(var1);
            if (!var3.isFullyFiltered()) {
                this.playersWithFullMessage.add(var0);
                IRegistryCustom var4 = var0.level.registryAccess();
                ChatMessageType.b var5 = var2.toNetwork(var4);
                var0.connection.send(new ClientboundPlayerChatPacket(var3, var5), PacketSendListener.exceptionallySend(() -> new ClientboundPlayerChatHeaderPacket(this.message)));
                var0.connection.addPendingMessage(var3);
            }
        }

        @Override
        public void sendHeadersToRemainingPlayers(PlayerList var0) {
            var0.broadcastMessageHeader(this.message, this.playersWithFullMessage);
        }
    }
}

