/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.time.Instant;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.MinecraftEncryption;

public record MessageSigner(UUID profileId, Instant timeStamp, long salt) {
    public MessageSigner(PacketDataSerializer var0) {
        this(var0.readUUID(), var0.readInstant(), var0.readLong());
    }

    public static MessageSigner create(UUID var0) {
        return new MessageSigner(var0, Instant.now(), MinecraftEncryption.c.getLong());
    }

    public static MessageSigner system() {
        return MessageSigner.create(SystemUtils.NIL_UUID);
    }

    public void write(PacketDataSerializer var0) {
        var0.writeUUID(this.profileId);
        var0.writeInstant(this.timeStamp);
        var0.writeLong(this.salt);
    }

    public boolean isSystem() {
        return this.profileId.equals(SystemUtils.NIL_UUID);
    }
}

