/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageHeader;
import net.minecraft.util.SignatureValidator;

public record MessageSignature(byte[] bytes) {
    public static final MessageSignature EMPTY = new MessageSignature(ByteArrays.EMPTY_ARRAY);

    public MessageSignature(PacketDataSerializer var0) {
        this(var0.readByteArray());
    }

    public void write(PacketDataSerializer var0) {
        var0.writeByteArray(this.bytes);
    }

    public boolean verify(SignatureValidator var0, SignedMessageHeader var1, SignedMessageBody var22) {
        if (!this.isEmpty()) {
            byte[] var3 = var22.hash().asBytes();
            return var0.validate(var2 -> var1.updateSignature(var2, var3), this.bytes);
        }
        return false;
    }

    public boolean verify(SignatureValidator var0, SignedMessageHeader var1, byte[] var22) {
        if (!this.isEmpty()) {
            return var0.validate(var2 -> var1.updateSignature(var2, var22), this.bytes);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    @Nullable
    public ByteBuffer asByteBuffer() {
        if (!this.isEmpty()) {
            return ByteBuffer.wrap(this.bytes);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object var0) {
        if (this == var0) return true;
        if (!(var0 instanceof MessageSignature)) return false;
        MessageSignature var1 = (MessageSignature)var0;
        if (!Arrays.equals(this.bytes, var1.bytes)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public String toString() {
        if (!this.isEmpty()) {
            return Base64.getEncoder().encodeToString(this.bytes);
        }
        return "empty";
    }
}

