/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.MessageSignature;

public record LastSeenMessages(List<a> entries) {
    public static LastSeenMessages EMPTY = new LastSeenMessages(List.of());
    public static final int LAST_SEEN_MESSAGES_MAX_LENGTH = 5;

    public LastSeenMessages(PacketDataSerializer var0) {
        this(var0.readCollection(PacketDataSerializer.limitValue(ArrayList::new, 5), a::new));
    }

    public void write(PacketDataSerializer var02) {
        var02.writeCollection(this.entries, (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
    }

    public void updateHash(DataOutput var0) throws IOException {
        for (a var2 : this.entries) {
            UUID var3 = var2.profileId();
            MessageSignature var4 = var2.lastSignature();
            var0.writeByte(70);
            var0.writeLong(var3.getMostSignificantBits());
            var0.writeLong(var3.getLeastSignificantBits());
            var0.write(var4.bytes());
        }
    }

    public record a(UUID profileId, MessageSignature lastSignature) {
        public a(PacketDataSerializer var0) {
            this(var0.readUUID(), new MessageSignature(var0));
        }

        public void write(PacketDataSerializer var0) {
            var0.writeUUID(this.profileId);
            this.lastSignature.write(var0);
        }
    }

    public record b(LastSeenMessages lastSeen, Optional<a> lastReceived) {
        public b(PacketDataSerializer var0) {
            this(new LastSeenMessages(var0), var0.readOptional(a::new));
        }

        public void write(PacketDataSerializer var02) {
            this.lastSeen.write(var02);
            var02.writeOptional(this.lastReceived, (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
        }
    }
}

