/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.EntityPlayer;

@FunctionalInterface
public interface ChatDecorator {
    public static final ChatDecorator PLAIN = (var0, var1) -> CompletableFuture.completedFuture(var1);

    public CompletableFuture<IChatBaseComponent> decorate(@Nullable EntityPlayer var1, IChatBaseComponent var2);

    default public CompletableFuture<PlayerChatMessage> decorate(@Nullable EntityPlayer var0, PlayerChatMessage var1) {
        if (var1.signedContent().isDecorated()) {
            return CompletableFuture.completedFuture(var1);
        }
        return this.decorate(var0, var1.serverContent()).thenApply(var1::withUnsignedContent);
    }

    public static PlayerChatMessage attachIfNotDecorated(PlayerChatMessage var0, IChatBaseComponent var1) {
        if (!var0.signedContent().isDecorated()) {
            return var0.withUnsignedContent(var1);
        }
        return var0;
    }
}

