/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class DynamicOpsNBT
implements DynamicOps<NBTBase> {
    public static final DynamicOpsNBT INSTANCE = new DynamicOpsNBT();

    protected DynamicOpsNBT() {
    }

    public NBTBase empty() {
        return NBTTagEnd.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> var0, NBTBase var1) {
        switch (var1.getId()) {
            case 0: {
                return (U)var0.empty();
            }
            case 1: {
                return (U)var0.createByte(((NBTNumber)var1).getAsByte());
            }
            case 2: {
                return (U)var0.createShort(((NBTNumber)var1).getAsShort());
            }
            case 3: {
                return (U)var0.createInt(((NBTNumber)var1).getAsInt());
            }
            case 4: {
                return (U)var0.createLong(((NBTNumber)var1).getAsLong());
            }
            case 5: {
                return (U)var0.createFloat(((NBTNumber)var1).getAsFloat());
            }
            case 6: {
                return (U)var0.createDouble(((NBTNumber)var1).getAsDouble());
            }
            case 7: {
                return (U)var0.createByteList(ByteBuffer.wrap(((NBTTagByteArray)var1).getAsByteArray()));
            }
            case 8: {
                return (U)var0.createString(var1.getAsString());
            }
            case 9: {
                return (U)this.convertList(var0, var1);
            }
            case 10: {
                return (U)this.convertMap(var0, var1);
            }
            case 11: {
                return (U)var0.createIntList(Arrays.stream(((NBTTagIntArray)var1).getAsIntArray()));
            }
            case 12: {
                return (U)var0.createLongList(Arrays.stream(((NBTTagLongArray)var1).getAsLongArray()));
            }
        }
        throw new IllegalStateException("Unknown tag type: " + var1);
    }

    public DataResult<Number> getNumberValue(NBTBase var0) {
        if (var0 instanceof NBTNumber) {
            return DataResult.success((Object)((NBTNumber)var0).getAsNumber());
        }
        return DataResult.error((String)"Not a number");
    }

    public NBTBase createNumeric(Number var0) {
        return NBTTagDouble.valueOf(var0.doubleValue());
    }

    public NBTBase createByte(byte var0) {
        return NBTTagByte.valueOf(var0);
    }

    public NBTBase createShort(short var0) {
        return NBTTagShort.valueOf(var0);
    }

    public NBTBase createInt(int var0) {
        return NBTTagInt.valueOf(var0);
    }

    public NBTBase createLong(long var0) {
        return NBTTagLong.valueOf(var0);
    }

    public NBTBase createFloat(float var0) {
        return NBTTagFloat.valueOf(var0);
    }

    public NBTBase createDouble(double var0) {
        return NBTTagDouble.valueOf(var0);
    }

    public NBTBase createBoolean(boolean var0) {
        return NBTTagByte.valueOf(var0);
    }

    public DataResult<String> getStringValue(NBTBase var0) {
        if (var0 instanceof NBTTagString) {
            return DataResult.success((Object)var0.getAsString());
        }
        return DataResult.error((String)"Not a string");
    }

    public NBTBase createString(String var0) {
        return NBTTagString.valueOf(var0);
    }

    private static NBTList<?> createGenericList(byte var0, byte var1) {
        if (DynamicOpsNBT.typesMatch(var0, var1, (byte)4)) {
            return new NBTTagLongArray(new long[0]);
        }
        if (DynamicOpsNBT.typesMatch(var0, var1, (byte)1)) {
            return new NBTTagByteArray(new byte[0]);
        }
        if (DynamicOpsNBT.typesMatch(var0, var1, (byte)3)) {
            return new NBTTagIntArray(new int[0]);
        }
        return new NBTTagList();
    }

    private static boolean typesMatch(byte var0, byte var1, byte var2) {
        return var0 == var2 && (var1 == var2 || var1 == 0);
    }

    private static <T extends NBTBase> void fillOne(NBTList<T> var0, NBTBase var12, NBTBase var2) {
        if (var12 instanceof NBTList) {
            NBTList var3 = (NBTList)var12;
            var3.forEach(var1 -> var0.add(var1));
        }
        var0.add(var2);
    }

    private static <T extends NBTBase> void fillMany(NBTList<T> var0, NBTBase var12, List<NBTBase> var2) {
        if (var12 instanceof NBTList) {
            NBTList var3 = (NBTList)var12;
            var3.forEach(var1 -> var0.add(var1));
        }
        var2.forEach(var1 -> var0.add(var1));
    }

    public DataResult<NBTBase> mergeToList(NBTBase var0, NBTBase var1) {
        if (!(var0 instanceof NBTList) && !(var0 instanceof NBTTagEnd)) {
            return DataResult.error((String)("mergeToList called with not a list: " + var0), (Object)var0);
        }
        NBTList<?> var2 = DynamicOpsNBT.createGenericList(var0 instanceof NBTList ? ((NBTList)var0).getElementType() : (byte)0, var1.getId());
        DynamicOpsNBT.fillOne(var2, var0, var1);
        return DataResult.success(var2);
    }

    public DataResult<NBTBase> mergeToList(NBTBase var0, List<NBTBase> var1) {
        if (!(var0 instanceof NBTList) && !(var0 instanceof NBTTagEnd)) {
            return DataResult.error((String)("mergeToList called with not a list: " + var0), (Object)var0);
        }
        NBTList<?> var2 = DynamicOpsNBT.createGenericList(var0 instanceof NBTList ? ((NBTList)var0).getElementType() : (byte)0, var1.stream().findFirst().map(NBTBase::getId).orElse((byte)0));
        DynamicOpsNBT.fillMany(var2, var0, var1);
        return DataResult.success(var2);
    }

    public DataResult<NBTBase> mergeToMap(NBTBase var0, NBTBase var1, NBTBase var22) {
        if (!(var0 instanceof NBTTagCompound) && !(var0 instanceof NBTTagEnd)) {
            return DataResult.error((String)("mergeToMap called with not a map: " + var0), (Object)var0);
        }
        if (!(var1 instanceof NBTTagString)) {
            return DataResult.error((String)("key is not a string: " + var1), (Object)var0);
        }
        NBTTagCompound var3 = new NBTTagCompound();
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var4 = (NBTTagCompound)var0;
            var4.getAllKeys().forEach(var2 -> var3.put((String)var2, var4.get((String)var2)));
        }
        var3.put(var1.getAsString(), var22);
        return DataResult.success((Object)var3);
    }

    public DataResult<NBTBase> mergeToMap(NBTBase var0, MapLike<NBTBase> var1) {
        Object var3;
        if (!(var0 instanceof NBTTagCompound) && !(var0 instanceof NBTTagEnd)) {
            return DataResult.error((String)("mergeToMap called with not a map: " + var0), (Object)var0);
        }
        NBTTagCompound var2 = new NBTTagCompound();
        if (var0 instanceof NBTTagCompound) {
            var3 = (NBTTagCompound)var0;
            ((NBTTagCompound)var3).getAllKeys().forEach(arg_0 -> DynamicOpsNBT.b(var2, (NBTTagCompound)var3, arg_0));
        }
        var3 = Lists.newArrayList();
        var1.entries().forEach(arg_0 -> DynamicOpsNBT.a((List)var3, var2, arg_0));
        if (!var3.isEmpty()) {
            return DataResult.error((String)("some keys are not strings: " + (List)var3), (Object)var2);
        }
        return DataResult.success((Object)var2);
    }

    public DataResult<Stream<Pair<NBTBase, NBTBase>>> getMapValues(NBTBase var0) {
        if (!(var0 instanceof NBTTagCompound)) {
            return DataResult.error((String)("Not a map: " + var0));
        }
        NBTTagCompound var12 = (NBTTagCompound)var0;
        return DataResult.success(var12.getAllKeys().stream().map(var1 -> Pair.of((Object)this.createString((String)var1), (Object)var12.get((String)var1))));
    }

    public DataResult<Consumer<BiConsumer<NBTBase, NBTBase>>> getMapEntries(NBTBase var0) {
        if (!(var0 instanceof NBTTagCompound)) {
            return DataResult.error((String)("Not a map: " + var0));
        }
        NBTTagCompound var12 = (NBTTagCompound)var0;
        return DataResult.success(var1 -> var12.getAllKeys().forEach(var2 -> var1.accept(this.createString((String)var2), var12.get((String)var2))));
    }

    public DataResult<MapLike<NBTBase>> getMap(NBTBase var0) {
        if (!(var0 instanceof NBTTagCompound)) {
            return DataResult.error((String)("Not a map: " + var0));
        }
        final NBTTagCompound var1 = (NBTTagCompound)var0;
        return DataResult.success((Object)new MapLike<NBTBase>(){

            @Nullable
            public NBTBase get(NBTBase var0) {
                return var1.get(var0.getAsString());
            }

            @Nullable
            public NBTBase get(String var0) {
                return var1.get(var0);
            }

            public Stream<Pair<NBTBase, NBTBase>> entries() {
                return var1.getAllKeys().stream().map(var1 -> Pair.of((Object)DynamicOpsNBT.this.createString((String)var1), (Object)var1.get((String)var1)));
            }

            public String toString() {
                return "MapLike[" + var1 + "]";
            }

            @Nullable
            public /* synthetic */ Object get(String string) {
                return this.get(string);
            }

            @Nullable
            public /* synthetic */ Object get(Object object) {
                return this.get((NBTBase)object);
            }
        });
    }

    public NBTBase createMap(Stream<Pair<NBTBase, NBTBase>> var0) {
        NBTTagCompound var12 = new NBTTagCompound();
        var0.forEach(var1 -> var12.put(((NBTBase)var1.getFirst()).getAsString(), (NBTBase)var1.getSecond()));
        return var12;
    }

    public DataResult<Stream<NBTBase>> getStream(NBTBase var02) {
        if (var02 instanceof NBTList) {
            return DataResult.success(((NBTList)var02).stream().map(var0 -> var0));
        }
        return DataResult.error((String)"Not a list");
    }

    public DataResult<Consumer<Consumer<NBTBase>>> getList(NBTBase var0) {
        if (var0 instanceof NBTList) {
            NBTList var1 = (NBTList)var0;
            return DataResult.success(var1::forEach);
        }
        return DataResult.error((String)("Not a list: " + var0));
    }

    public DataResult<ByteBuffer> getByteBuffer(NBTBase var0) {
        if (var0 instanceof NBTTagByteArray) {
            return DataResult.success((Object)ByteBuffer.wrap(((NBTTagByteArray)var0).getAsByteArray()));
        }
        return super.getByteBuffer((Object)var0);
    }

    public NBTBase createByteList(ByteBuffer var0) {
        return new NBTTagByteArray(DataFixUtils.toArray((ByteBuffer)var0));
    }

    public DataResult<IntStream> getIntStream(NBTBase var0) {
        if (var0 instanceof NBTTagIntArray) {
            return DataResult.success((Object)Arrays.stream(((NBTTagIntArray)var0).getAsIntArray()));
        }
        return super.getIntStream((Object)var0);
    }

    public NBTBase createIntList(IntStream var0) {
        return new NBTTagIntArray(var0.toArray());
    }

    public DataResult<LongStream> getLongStream(NBTBase var0) {
        if (var0 instanceof NBTTagLongArray) {
            return DataResult.success((Object)Arrays.stream(((NBTTagLongArray)var0).getAsLongArray()));
        }
        return super.getLongStream((Object)var0);
    }

    public NBTBase createLongList(LongStream var0) {
        return new NBTTagLongArray(var0.toArray());
    }

    public NBTBase createList(Stream<NBTBase> var02) {
        PeekingIterator var1 = Iterators.peekingIterator(var02.iterator());
        if (!var1.hasNext()) {
            return new NBTTagList();
        }
        NBTBase var2 = (NBTBase)var1.peek();
        if (var2 instanceof NBTTagByte) {
            ArrayList var3 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)var1, var0 -> ((NBTTagByte)var0).getAsByte()));
            return new NBTTagByteArray(var3);
        }
        if (var2 instanceof NBTTagInt) {
            ArrayList var3 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)var1, var0 -> ((NBTTagInt)var0).getAsInt()));
            return new NBTTagIntArray(var3);
        }
        if (var2 instanceof NBTTagLong) {
            ArrayList var3 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)var1, var0 -> ((NBTTagLong)var0).getAsLong()));
            return new NBTTagLongArray(var3);
        }
        NBTTagList var3 = new NBTTagList();
        while (var1.hasNext()) {
            NBTBase var4 = (NBTBase)var1.next();
            if (var4 instanceof NBTTagEnd) continue;
            var3.add(var4);
        }
        return var3;
    }

    public NBTBase remove(NBTBase var0, String var12) {
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var22 = (NBTTagCompound)var0;
            NBTTagCompound var3 = new NBTTagCompound();
            var22.getAllKeys().stream().filter(var1 -> !Objects.equals(var1, var12)).forEach(var2 -> var3.put((String)var2, var22.get((String)var2)));
            return var3;
        }
        return var0;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<NBTBase> mapBuilder() {
        return new a();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((NBTBase)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((NBTBase)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((NBTBase)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((NBTBase)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((NBTBase)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((NBTBase)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((NBTBase)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((NBTBase)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((NBTBase)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((NBTBase)object, (MapLike<NBTBase>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((NBTBase)object, (NBTBase)object2, (NBTBase)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((NBTBase)object, (List<NBTBase>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((NBTBase)object, (NBTBase)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((NBTBase)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ Object createDouble(double d2) {
        return this.createDouble(d2);
    }

    public /* synthetic */ Object createFloat(float f2) {
        return this.createFloat(f2);
    }

    public /* synthetic */ Object createLong(long l2) {
        return this.createLong(l2);
    }

    public /* synthetic */ Object createInt(int n2) {
        return this.createInt(n2);
    }

    public /* synthetic */ Object createShort(short s2) {
        return this.createShort(s2);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((NBTBase)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (NBTBase)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    private static /* synthetic */ void a(List var0, NBTTagCompound var1, Pair var2) {
        NBTBase var3 = (NBTBase)var2.getFirst();
        if (!(var3 instanceof NBTTagString)) {
            var0.add(var3);
            return;
        }
        var1.put(var3.getAsString(), (NBTBase)var2.getSecond());
    }

    private static /* synthetic */ void b(NBTTagCompound var0, NBTTagCompound var1, String var2) {
        var0.put(var2, var1.get(var2));
    }

    class a
    extends RecordBuilder.AbstractStringBuilder<NBTBase, NBTTagCompound> {
        protected a() {
            super((DynamicOps)DynamicOpsNBT.this);
        }

        protected NBTTagCompound initBuilder() {
            return new NBTTagCompound();
        }

        protected NBTTagCompound append(String var0, NBTBase var1, NBTTagCompound var2) {
            var2.put(var0, var1);
            return var2;
        }

        protected DataResult<NBTBase> build(NBTTagCompound var0, NBTBase var1) {
            if (var1 == null || var1 == NBTTagEnd.INSTANCE) {
                return DataResult.success((Object)var0);
            }
            if (var1 instanceof NBTTagCompound) {
                NBTTagCompound var2 = new NBTTagCompound(Maps.newHashMap(((NBTTagCompound)var1).entries()));
                for (Map.Entry<String, NBTBase> var4 : var0.entries().entrySet()) {
                    var2.put(var4.getKey(), var4.getValue());
                }
                return DataResult.success((Object)var2);
            }
            return DataResult.error((String)("mergeToMap called with not a map: " + var1), (Object)var1);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.append(string, (NBTBase)object, (NBTTagCompound)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((NBTTagCompound)object, (NBTBase)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }
}

