/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.data.worldgen.AncientCityStructurePieces;
import net.minecraft.data.worldgen.WorldGenFeatureBastionPieces;
import net.minecraft.data.worldgen.WorldGenFeatureDesertVillage;
import net.minecraft.data.worldgen.WorldGenFeaturePillagerOutpostPieces;
import net.minecraft.data.worldgen.WorldGenFeatureVillagePlain;
import net.minecraft.data.worldgen.WorldGenFeatureVillageSavanna;
import net.minecraft.data.worldgen.WorldGenFeatureVillageSnowy;
import net.minecraft.data.worldgen.WorldGenFeatureVillageTaiga;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidStructure;
import net.minecraft.world.level.levelgen.structure.structures.EndCityStructure;
import net.minecraft.world.level.levelgen.structure.structures.IglooStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.structures.JungleTempleStructure;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure;
import net.minecraft.world.level.levelgen.structure.structures.ShipwreckStructure;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure;
import net.minecraft.world.level.levelgen.structure.structures.SwampHutStructure;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure;

public class Structures {
    public static final Holder<Structure> PILLAGER_OUTPOST = Structures.register(BuiltinStructures.PILLAGER_OUTPOST, new JigsawStructure(Structures.structure(BiomeTags.HAS_PILLAGER_OUTPOST, Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.PILLAGER, 1, 1, 1)}))), WorldGenStage.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), WorldGenFeaturePillagerOutpostPieces.START, 7, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
    public static final Holder<Structure> MINESHAFT = Structures.register(BuiltinStructures.MINESHAFT, new MineshaftStructure(Structures.structure(BiomeTags.HAS_MINESHAFT, WorldGenStage.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE), MineshaftStructure.a.NORMAL));
    public static final Holder<Structure> MINESHAFT_MESA = Structures.register(BuiltinStructures.MINESHAFT_MESA, new MineshaftStructure(Structures.structure(BiomeTags.HAS_MINESHAFT_MESA, WorldGenStage.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE), MineshaftStructure.a.MESA));
    public static final Holder<Structure> WOODLAND_MANSION = Structures.register(BuiltinStructures.WOODLAND_MANSION, new WoodlandMansionStructure(Structures.structure(BiomeTags.HAS_WOODLAND_MANSION, TerrainAdjustment.NONE)));
    public static final Holder<Structure> JUNGLE_TEMPLE = Structures.register(BuiltinStructures.JUNGLE_TEMPLE, new JungleTempleStructure(Structures.structure(BiomeTags.HAS_JUNGLE_TEMPLE, TerrainAdjustment.NONE)));
    public static final Holder<Structure> DESERT_PYRAMID = Structures.register(BuiltinStructures.DESERT_PYRAMID, new DesertPyramidStructure(Structures.structure(BiomeTags.HAS_DESERT_PYRAMID, TerrainAdjustment.NONE)));
    public static final Holder<Structure> IGLOO = Structures.register(BuiltinStructures.IGLOO, new IglooStructure(Structures.structure(BiomeTags.HAS_IGLOO, TerrainAdjustment.NONE)));
    public static final Holder<Structure> SHIPWRECK = Structures.register(BuiltinStructures.SHIPWRECK, new ShipwreckStructure(Structures.structure(BiomeTags.HAS_SHIPWRECK, TerrainAdjustment.NONE), false));
    public static final Holder<Structure> SHIPWRECK_BEACHED = Structures.register(BuiltinStructures.SHIPWRECK_BEACHED, new ShipwreckStructure(Structures.structure(BiomeTags.HAS_SHIPWRECK_BEACHED, TerrainAdjustment.NONE), true));
    public static final Holder<Structure> SWAMP_HUT = Structures.register(BuiltinStructures.SWAMP_HUT, new SwampHutStructure(Structures.structure(BiomeTags.HAS_SWAMP_HUT, Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.WITCH, 1, 1, 1)})), EnumCreatureType.CREATURE, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.CAT, 1, 1, 1)}))), WorldGenStage.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
    public static final Holder<Structure> STRONGHOLD = Structures.register(BuiltinStructures.STRONGHOLD, new StrongholdStructure(Structures.structure(BiomeTags.HAS_STRONGHOLD, TerrainAdjustment.BURY)));
    public static final Holder<Structure> OCEAN_MONUMENT = Structures.register(BuiltinStructures.OCEAN_MONUMENT, new OceanMonumentStructure(Structures.structure(BiomeTags.HAS_OCEAN_MONUMENT, Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.GUARDIAN, 1, 2, 4)})), EnumCreatureType.UNDERGROUND_WATER_CREATURE, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, BiomeSettingsMobs.EMPTY_MOB_LIST), EnumCreatureType.AXOLOTLS, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, BiomeSettingsMobs.EMPTY_MOB_LIST)), WorldGenStage.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
    public static final Holder<Structure> OCEAN_RUIN_COLD = Structures.register(BuiltinStructures.OCEAN_RUIN_COLD, new OceanRuinStructure(Structures.structure(BiomeTags.HAS_OCEAN_RUIN_COLD, TerrainAdjustment.NONE), OceanRuinStructure.a.COLD, 0.3f, 0.9f));
    public static final Holder<Structure> OCEAN_RUIN_WARM = Structures.register(BuiltinStructures.OCEAN_RUIN_WARM, new OceanRuinStructure(Structures.structure(BiomeTags.HAS_OCEAN_RUIN_WARM, TerrainAdjustment.NONE), OceanRuinStructure.a.WARM, 0.3f, 0.9f));
    public static final Holder<Structure> FORTRESS = Structures.register(BuiltinStructures.FORTRESS, new NetherFortressStructure(Structures.structure(BiomeTags.HAS_NETHER_FORTRESS, Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, NetherFortressStructure.FORTRESS_ENEMIES)), WorldGenStage.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.NONE)));
    public static final Holder<Structure> NETHER_FOSSIL = Structures.register(BuiltinStructures.NETHER_FOSSIL, new NetherFossilStructure(Structures.structure(BiomeTags.HAS_NETHER_FOSSIL, WorldGenStage.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.BEARD_THIN), UniformHeight.of(VerticalAnchor.absolute(32), VerticalAnchor.belowTop(2))));
    public static final Holder<Structure> END_CITY = Structures.register(BuiltinStructures.END_CITY, new EndCityStructure(Structures.structure(BiomeTags.HAS_END_CITY, TerrainAdjustment.NONE)));
    public static final Holder<Structure> BURIED_TREASURE = Structures.register(BuiltinStructures.BURIED_TREASURE, new BuriedTreasureStructure(Structures.structure(BiomeTags.HAS_BURIED_TREASURE, WorldGenStage.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE)));
    public static final Holder<Structure> BASTION_REMNANT = Structures.register(BuiltinStructures.BASTION_REMNANT, new JigsawStructure(Structures.structure(BiomeTags.HAS_BASTION_REMNANT, TerrainAdjustment.NONE), WorldGenFeatureBastionPieces.START, 6, ConstantHeight.of(VerticalAnchor.absolute(33)), false));
    public static final Holder<Structure> VILLAGE_PLAINS = Structures.register(BuiltinStructures.VILLAGE_PLAINS, new JigsawStructure(Structures.structure(BiomeTags.HAS_VILLAGE_PLAINS, TerrainAdjustment.BEARD_THIN), WorldGenFeatureVillagePlain.START, 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
    public static final Holder<Structure> VILLAGE_DESERT = Structures.register(BuiltinStructures.VILLAGE_DESERT, new JigsawStructure(Structures.structure(BiomeTags.HAS_VILLAGE_DESERT, TerrainAdjustment.BEARD_THIN), WorldGenFeatureDesertVillage.START, 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
    public static final Holder<Structure> VILLAGE_SAVANNA = Structures.register(BuiltinStructures.VILLAGE_SAVANNA, new JigsawStructure(Structures.structure(BiomeTags.HAS_VILLAGE_SAVANNA, TerrainAdjustment.BEARD_THIN), WorldGenFeatureVillageSavanna.START, 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
    public static final Holder<Structure> VILLAGE_SNOWY = Structures.register(BuiltinStructures.VILLAGE_SNOWY, new JigsawStructure(Structures.structure(BiomeTags.HAS_VILLAGE_SNOWY, TerrainAdjustment.BEARD_THIN), WorldGenFeatureVillageSnowy.START, 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
    public static final Holder<Structure> VILLAGE_TAIGA = Structures.register(BuiltinStructures.VILLAGE_TAIGA, new JigsawStructure(Structures.structure(BiomeTags.HAS_VILLAGE_TAIGA, TerrainAdjustment.BEARD_THIN), WorldGenFeatureVillageTaiga.START, 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
    public static final Holder<Structure> RUINED_PORTAL_STANDARD = Structures.register(BuiltinStructures.RUINED_PORTAL_STANDARD, new RuinedPortalStructure(Structures.structure(BiomeTags.HAS_RUINED_PORTAL_STANDARD, TerrainAdjustment.NONE), List.of(new RuinedPortalStructure.a(RuinedPortalPiece.b.UNDERGROUND, 1.0f, 0.2f, false, false, true, false, 0.5f), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5f, 0.2f, false, false, true, false, 0.5f))));
    public static final Holder<Structure> RUINED_PORTAL_DESERT = Structures.register(BuiltinStructures.RUINED_PORTAL_DESERT, new RuinedPortalStructure(Structures.structure(BiomeTags.HAS_RUINED_PORTAL_DESERT, TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.PARTLY_BURIED, 0.0f, 0.0f, false, false, false, false, 1.0f)));
    public static final Holder<Structure> RUINED_PORTAL_JUNGLE = Structures.register(BuiltinStructures.RUINED_PORTAL_JUNGLE, new RuinedPortalStructure(Structures.structure(BiomeTags.HAS_RUINED_PORTAL_JUNGLE, TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5f, 0.8f, true, true, false, false, 1.0f)));
    public static final Holder<Structure> RUINED_PORTAL_SWAMP = Structures.register(BuiltinStructures.RUINED_PORTAL_SWAMP, new RuinedPortalStructure(Structures.structure(BiomeTags.HAS_RUINED_PORTAL_SWAMP, TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_OCEAN_FLOOR, 0.0f, 0.5f, false, true, false, false, 1.0f)));
    public static final Holder<Structure> RUINED_PORTAL_MOUNTAIN = Structures.register(BuiltinStructures.RUINED_PORTAL_MOUNTAIN, new RuinedPortalStructure(Structures.structure(BiomeTags.HAS_RUINED_PORTAL_MOUNTAIN, TerrainAdjustment.NONE), List.of(new RuinedPortalStructure.a(RuinedPortalPiece.b.IN_MOUNTAIN, 1.0f, 0.2f, false, false, true, false, 0.5f), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5f, 0.2f, false, false, true, false, 0.5f))));
    public static final Holder<Structure> RUINED_PORTAL_OCEAN = Structures.register(BuiltinStructures.RUINED_PORTAL_OCEAN, new RuinedPortalStructure(Structures.structure(BiomeTags.HAS_RUINED_PORTAL_OCEAN, TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_OCEAN_FLOOR, 0.0f, 0.8f, false, false, true, false, 1.0f)));
    public static final Holder<Structure> RUINED_PORTAL_NETHER = Structures.register(BuiltinStructures.RUINED_PORTAL_NETHER, new RuinedPortalStructure(Structures.structure(BiomeTags.HAS_RUINED_PORTAL_NETHER, TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.IN_NETHER, 0.5f, 0.0f, false, false, false, true, 1.0f)));
    public static final Holder<Structure> ANCIENT_CITY = Structures.register(BuiltinStructures.ANCIENT_CITY, new JigsawStructure(Structures.structure(BiomeTags.HAS_ANCIENT_CITY, Arrays.stream(EnumCreatureType.values()).collect(Collectors.toMap(var0 -> var0, var0 -> new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create()))), WorldGenStage.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.BEARD_BOX), AncientCityStructurePieces.START, Optional.of(new MinecraftKey("city_anchor")), 7, ConstantHeight.of(VerticalAnchor.absolute(-27)), false, Optional.empty(), 116));

    public static Holder<? extends Structure> bootstrap(IRegistry<Structure> var0) {
        return MINESHAFT;
    }

    private static Structure.c structure(TagKey<BiomeBase> var0, Map<EnumCreatureType, StructureSpawnOverride> var1, WorldGenStage.Decoration var2, TerrainAdjustment var3) {
        return new Structure.c(Structures.biomes(var0), var1, var2, var3);
    }

    private static Structure.c structure(TagKey<BiomeBase> var0, WorldGenStage.Decoration var1, TerrainAdjustment var2) {
        return Structures.structure(var0, Map.of(), var1, var2);
    }

    private static Structure.c structure(TagKey<BiomeBase> var0, TerrainAdjustment var1) {
        return Structures.structure(var0, Map.of(), WorldGenStage.Decoration.SURFACE_STRUCTURES, var1);
    }

    private static Holder<Structure> register(ResourceKey<Structure> var0, Structure var1) {
        return RegistryGeneration.register(RegistryGeneration.STRUCTURES, var0, var1);
    }

    private static HolderSet<BiomeBase> biomes(TagKey<BiomeBase> var0) {
        return RegistryGeneration.BIOME.getOrCreateTag(var0);
    }
}

