/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import org.slf4j.Logger;

public class DebugReportNBT
implements DebugReportProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DebugReportGenerator generator;

    public DebugReportNBT(DebugReportGenerator var0) {
        this.generator = var0;
    }

    @Override
    public void run(CachedOutput var02) throws IOException {
        Path var1 = this.generator.getOutputFolder();
        for (Path var32 : this.generator.getInputFolders()) {
            Files.walk(var32, new FileVisitOption[0]).filter(var0 -> var0.toString().endsWith(".nbt")).forEach(var3 -> DebugReportNBT.convertStructure(var02, var3, this.getName(var32, (Path)var3), var1));
        }
    }

    @Override
    public String getName() {
        return "NBT to SNBT";
    }

    private String getName(Path var0, Path var1) {
        String var2 = var0.relativize(var1).toString().replaceAll("\\\\", "/");
        return var2.substring(0, var2.length() - ".nbt".length());
    }

    @Nullable
    public static Path convertStructure(CachedOutput var0, Path var1, String var2, Path var3) {
        Path path;
        block8: {
            InputStream var4 = Files.newInputStream(var1, new OpenOption[0]);
            try {
                Path var5 = var3.resolve(var2 + ".snbt");
                DebugReportNBT.writeSnbt(var0, var5, GameProfileSerializer.structureToSnbt(NBTCompressedStreamTools.readCompressed(var4)));
                LOGGER.info("Converted {} from NBT to SNBT", (Object)var2);
                path = var5;
                if (var4 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (var4 != null) {
                        try {
                            var4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException var42) {
                    LOGGER.error("Couldn't convert {} from NBT to SNBT at {}", new Object[]{var2, var1, var42});
                    return null;
                }
            }
            var4.close();
        }
        return path;
    }

    public static void writeSnbt(CachedOutput var0, Path var1, String var2) throws IOException {
        ByteArrayOutputStream var3 = new ByteArrayOutputStream();
        HashingOutputStream var4 = new HashingOutputStream(Hashing.sha1(), (OutputStream)var3);
        var4.write(var2.getBytes(StandardCharsets.UTF_8));
        var4.write(10);
        var0.writeIfNeeded(var1, var3.toByteArray(), var4.hash());
    }
}

