/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.worldgen.DimensionTypes;
import net.minecraft.data.worldgen.NoiseData;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.StructureSets;
import net.minecraft.data.worldgen.Structures;
import net.minecraft.data.worldgen.WorldGenCarvers;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.data.worldgen.biome.BiomeRegistry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPresets;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryGeneration {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<? extends Holder<?>>> LOADERS = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> WRITABLE_REGISTRY = new RegistryMaterials(ResourceKey.createRegistryKey(new MinecraftKey("root")), Lifecycle.experimental(), null);
    public static final IRegistry<? extends IRegistry<?>> REGISTRY = WRITABLE_REGISTRY;
    public static final IRegistry<DimensionManager> DIMENSION_TYPE = RegistryGeneration.registerSimple(IRegistry.DIMENSION_TYPE_REGISTRY, DimensionTypes::bootstrap);
    public static final IRegistry<WorldGenCarverWrapper<?>> CONFIGURED_CARVER = RegistryGeneration.registerSimple(IRegistry.CONFIGURED_CARVER_REGISTRY, var0 -> WorldGenCarvers.CAVE);
    public static final IRegistry<WorldGenFeatureConfigured<?, ?>> CONFIGURED_FEATURE = RegistryGeneration.registerSimple(IRegistry.CONFIGURED_FEATURE_REGISTRY, FeatureUtils::bootstrap);
    public static final IRegistry<PlacedFeature> PLACED_FEATURE = RegistryGeneration.registerSimple(IRegistry.PLACED_FEATURE_REGISTRY, PlacementUtils::bootstrap);
    public static final IRegistry<Structure> STRUCTURES = RegistryGeneration.registerSimple(IRegistry.STRUCTURE_REGISTRY, Structures::bootstrap);
    public static final IRegistry<StructureSet> STRUCTURE_SETS = RegistryGeneration.registerSimple(IRegistry.STRUCTURE_SET_REGISTRY, StructureSets::bootstrap);
    public static final IRegistry<ProcessorList> PROCESSOR_LIST = RegistryGeneration.registerSimple(IRegistry.PROCESSOR_LIST_REGISTRY, var0 -> ProcessorLists.ZOMBIE_PLAINS);
    public static final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> TEMPLATE_POOL = RegistryGeneration.registerSimple(IRegistry.TEMPLATE_POOL_REGISTRY, WorldGenFeaturePieces::bootstrap);
    public static final IRegistry<BiomeBase> BIOME = RegistryGeneration.registerSimple(IRegistry.BIOME_REGISTRY, BiomeRegistry::bootstrap);
    public static final IRegistry<NoiseGeneratorNormal.a> NOISE = RegistryGeneration.registerSimple(IRegistry.NOISE_REGISTRY, NoiseData::bootstrap);
    public static final IRegistry<DensityFunction> DENSITY_FUNCTION = RegistryGeneration.registerSimple(IRegistry.DENSITY_FUNCTION_REGISTRY, NoiseRouterData::bootstrap);
    public static final IRegistry<GeneratorSettingBase> NOISE_GENERATOR_SETTINGS = RegistryGeneration.registerSimple(IRegistry.NOISE_GENERATOR_SETTINGS_REGISTRY, GeneratorSettingBase::bootstrap);
    public static final IRegistry<WorldPreset> WORLD_PRESET = RegistryGeneration.registerSimple(IRegistry.WORLD_PRESET_REGISTRY, WorldPresets::bootstrap);
    public static final IRegistry<FlatLevelGeneratorPreset> FLAT_LEVEL_GENERATOR_PRESET = RegistryGeneration.registerSimple(IRegistry.FLAT_LEVEL_GENERATOR_PRESET_REGISTRY, FlatLevelGeneratorPresets::bootstrap);
    public static final IRegistry<ChatMessageType> CHAT_TYPE = RegistryGeneration.registerSimple(IRegistry.CHAT_TYPE_REGISTRY, ChatMessageType::bootstrap);
    public static final IRegistryCustom ACCESS;

    private static <T> IRegistry<T> registerSimple(ResourceKey<? extends IRegistry<T>> var0, a<T> var1) {
        return RegistryGeneration.registerSimple(var0, Lifecycle.stable(), var1);
    }

    private static <T> IRegistry<T> registerSimple(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1, a<T> var2) {
        return RegistryGeneration.internalRegister(var0, new RegistryMaterials(var0, var1, null), var2, var1);
    }

    private static <T, R extends IRegistryWritable<T>> R internalRegister(ResourceKey<? extends IRegistry<T>> var0, R var1, a<T> var2, Lifecycle var3) {
        MinecraftKey var4 = var0.location();
        LOADERS.put(var4, () -> var2.run(var1));
        WRITABLE_REGISTRY.register(var0, var1, var3);
        return var1;
    }

    public static <V extends T, T> Holder<V> registerExact(IRegistry<T> var0, String var1, V var2) {
        Holder<T> var3 = RegistryGeneration.register(var0, new MinecraftKey(var1), var2);
        return var3;
    }

    public static <T> Holder<T> register(IRegistry<T> var0, String var1, T var2) {
        return RegistryGeneration.register(var0, new MinecraftKey(var1), var2);
    }

    public static <T> Holder<T> register(IRegistry<T> var0, MinecraftKey var1, T var2) {
        return RegistryGeneration.register(var0, ResourceKey.create(var0.key(), var1), var2);
    }

    public static <T> Holder<T> register(IRegistry<T> var0, ResourceKey<T> var1, T var2) {
        return ((IRegistryWritable)var0).register(var1, var2, Lifecycle.stable());
    }

    public static void bootstrap() {
    }

    static {
        LOADERS.forEach((var0, var1) -> {
            if (!((Holder)var1.get()).isBound()) {
                LOGGER.error("Unable to bootstrap registry '{}'", var0);
            }
        });
        IRegistry.checkRegistry(WRITABLE_REGISTRY);
        ACCESS = IRegistryCustom.fromRegistryOfRegistries(REGISTRY);
    }

    @FunctionalInterface
    static interface a<T> {
        public Holder<? extends T> run(IRegistry<T> var1);
    }
}

