/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.PacketDataSerializer;

public class ShriekParticleOption
implements ParticleParam {
    public static final Codec<ShriekParticleOption> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("delay").forGetter(var0 -> var0.delay)).apply((Applicative)var02, ShriekParticleOption::new));
    public static final ParticleParam.a<ShriekParticleOption> DESERIALIZER = new ParticleParam.a<ShriekParticleOption>(){

        @Override
        public ShriekParticleOption fromCommand(Particle<ShriekParticleOption> var0, StringReader var1) throws CommandSyntaxException {
            var1.expect(' ');
            int var2 = var1.readInt();
            return new ShriekParticleOption(var2);
        }

        @Override
        public ShriekParticleOption fromNetwork(Particle<ShriekParticleOption> var0, PacketDataSerializer var1) {
            return new ShriekParticleOption(var1.readVarInt());
        }

        @Override
        public /* synthetic */ ParticleParam fromNetwork(Particle particle, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(particle, packetDataSerializer);
        }

        @Override
        public /* synthetic */ ParticleParam fromCommand(Particle particle, StringReader stringReader) throws CommandSyntaxException {
            return this.fromCommand(particle, stringReader);
        }
    };
    private final int delay;

    public ShriekParticleOption(int var0) {
        this.delay = var0;
    }

    @Override
    public void writeToNetwork(PacketDataSerializer var0) {
        var0.writeVarInt(this.delay);
    }

    @Override
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %d", IRegistry.PARTICLE_TYPE.getKey(this.getType()), this.delay);
    }

    public Particle<ShriekParticleOption> getType() {
        return Particles.SHRIEK;
    }

    public int getDelay() {
        return this.delay;
    }
}

