/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.cauldron;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.IDyeable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public interface CauldronInteraction {
    public static final Map<Item, CauldronInteraction> EMPTY = CauldronInteraction.newInteractionMap();
    public static final Map<Item, CauldronInteraction> WATER = CauldronInteraction.newInteractionMap();
    public static final Map<Item, CauldronInteraction> LAVA = CauldronInteraction.newInteractionMap();
    public static final Map<Item, CauldronInteraction> POWDER_SNOW = CauldronInteraction.newInteractionMap();
    public static final CauldronInteraction FILL_WATER = (var0, var1, var2, var3, var4, var5) -> CauldronInteraction.emptyBucket(var1, var2, var3, var4, var5, (IBlockData)Blocks.WATER_CAULDRON.defaultBlockState().setValue(LayeredCauldronBlock.LEVEL, 3), SoundEffects.BUCKET_EMPTY);
    public static final CauldronInteraction FILL_LAVA = (var0, var1, var2, var3, var4, var5) -> CauldronInteraction.emptyBucket(var1, var2, var3, var4, var5, Blocks.LAVA_CAULDRON.defaultBlockState(), SoundEffects.BUCKET_EMPTY_LAVA);
    public static final CauldronInteraction FILL_POWDER_SNOW = (var0, var1, var2, var3, var4, var5) -> CauldronInteraction.emptyBucket(var1, var2, var3, var4, var5, (IBlockData)Blocks.POWDER_SNOW_CAULDRON.defaultBlockState().setValue(LayeredCauldronBlock.LEVEL, 3), SoundEffects.BUCKET_EMPTY_POWDER_SNOW);
    public static final CauldronInteraction SHULKER_BOX = (var0, var1, var2, var3, var4, var5) -> {
        Block var6 = Block.byItem(var5.getItem());
        if (!(var6 instanceof BlockShulkerBox)) {
            return EnumInteractionResult.PASS;
        }
        if (!var1.isClientSide) {
            ItemStack var7 = new ItemStack(Blocks.SHULKER_BOX);
            if (var5.hasTag()) {
                var7.setTag(var5.getTag().copy());
            }
            var3.setItemInHand(var4, var7);
            var3.awardStat(StatisticList.CLEAN_SHULKER_BOX);
            LayeredCauldronBlock.lowerFillLevel(var0, var1, var2);
        }
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    };
    public static final CauldronInteraction BANNER = (var0, var1, var2, var3, var4, var5) -> {
        if (TileEntityBanner.getPatternCount(var5) <= 0) {
            return EnumInteractionResult.PASS;
        }
        if (!var1.isClientSide) {
            ItemStack var6 = var5.copy();
            var6.setCount(1);
            TileEntityBanner.removeLastPattern(var6);
            if (!var3.getAbilities().instabuild) {
                var5.shrink(1);
            }
            if (var5.isEmpty()) {
                var3.setItemInHand(var4, var6);
            } else if (var3.getInventory().add(var6)) {
                var3.inventoryMenu.sendAllDataToRemote();
            } else {
                var3.drop(var6, false);
            }
            var3.awardStat(StatisticList.CLEAN_BANNER);
            LayeredCauldronBlock.lowerFillLevel(var0, var1, var2);
        }
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    };
    public static final CauldronInteraction DYED_ITEM = (var0, var1, var2, var3, var4, var5) -> {
        Item var6 = var5.getItem();
        if (!(var6 instanceof IDyeable)) {
            return EnumInteractionResult.PASS;
        }
        IDyeable var7 = (IDyeable)((Object)var6);
        if (!var7.hasCustomColor(var5)) {
            return EnumInteractionResult.PASS;
        }
        if (!var1.isClientSide) {
            var7.clearColor(var5);
            var3.awardStat(StatisticList.CLEAN_ARMOR);
            LayeredCauldronBlock.lowerFillLevel(var0, var1, var2);
        }
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    };

    public static Object2ObjectOpenHashMap<Item, CauldronInteraction> newInteractionMap() {
        return SystemUtils.make(new Object2ObjectOpenHashMap(), var02 -> var02.defaultReturnValue((var0, var1, var2, var3, var4, var5) -> EnumInteractionResult.PASS));
    }

    public EnumInteractionResult interact(IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, ItemStack var6);

    public static void bootStrap() {
        CauldronInteraction.addDefaultInteractions(EMPTY);
        EMPTY.put(Items.POTION, (var0, var1, var2, var3, var4, var5) -> {
            if (PotionUtil.getPotion(var5) != Potions.WATER) {
                return EnumInteractionResult.PASS;
            }
            if (!var1.isClientSide) {
                Item var6 = var5.getItem();
                var3.setItemInHand(var4, ItemLiquidUtil.createFilledResult(var5, var3, new ItemStack(Items.GLASS_BOTTLE)));
                var3.awardStat(StatisticList.USE_CAULDRON);
                var3.awardStat(StatisticList.ITEM_USED.get(var6));
                var1.setBlockAndUpdate(var2, Blocks.WATER_CAULDRON.defaultBlockState());
                var1.playSound(null, var2, SoundEffects.BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                var1.gameEvent(null, GameEvent.FLUID_PLACE, var2);
            }
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        });
        CauldronInteraction.addDefaultInteractions(WATER);
        WATER.put(Items.BUCKET, (var02, var1, var2, var3, var4, var5) -> CauldronInteraction.fillBucket(var02, var1, var2, var3, var4, var5, new ItemStack(Items.WATER_BUCKET), var0 -> var0.getValue(LayeredCauldronBlock.LEVEL) == 3, SoundEffects.BUCKET_FILL));
        WATER.put(Items.GLASS_BOTTLE, (var0, var1, var2, var3, var4, var5) -> {
            if (!var1.isClientSide) {
                Item var6 = var5.getItem();
                var3.setItemInHand(var4, ItemLiquidUtil.createFilledResult(var5, var3, PotionUtil.setPotion(new ItemStack(Items.POTION), Potions.WATER)));
                var3.awardStat(StatisticList.USE_CAULDRON);
                var3.awardStat(StatisticList.ITEM_USED.get(var6));
                LayeredCauldronBlock.lowerFillLevel(var0, var1, var2);
                var1.playSound(null, var2, SoundEffects.BOTTLE_FILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                var1.gameEvent(null, GameEvent.FLUID_PICKUP, var2);
            }
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        });
        WATER.put(Items.POTION, (var0, var1, var2, var3, var4, var5) -> {
            if (var0.getValue(LayeredCauldronBlock.LEVEL) == 3 || PotionUtil.getPotion(var5) != Potions.WATER) {
                return EnumInteractionResult.PASS;
            }
            if (!var1.isClientSide) {
                var3.setItemInHand(var4, ItemLiquidUtil.createFilledResult(var5, var3, new ItemStack(Items.GLASS_BOTTLE)));
                var3.awardStat(StatisticList.USE_CAULDRON);
                var3.awardStat(StatisticList.ITEM_USED.get(var5.getItem()));
                var1.setBlockAndUpdate(var2, (IBlockData)var0.cycle(LayeredCauldronBlock.LEVEL));
                var1.playSound(null, var2, SoundEffects.BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                var1.gameEvent(null, GameEvent.FLUID_PLACE, var2);
            }
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        });
        WATER.put(Items.LEATHER_BOOTS, DYED_ITEM);
        WATER.put(Items.LEATHER_LEGGINGS, DYED_ITEM);
        WATER.put(Items.LEATHER_CHESTPLATE, DYED_ITEM);
        WATER.put(Items.LEATHER_HELMET, DYED_ITEM);
        WATER.put(Items.LEATHER_HORSE_ARMOR, DYED_ITEM);
        WATER.put(Items.WHITE_BANNER, BANNER);
        WATER.put(Items.GRAY_BANNER, BANNER);
        WATER.put(Items.BLACK_BANNER, BANNER);
        WATER.put(Items.BLUE_BANNER, BANNER);
        WATER.put(Items.BROWN_BANNER, BANNER);
        WATER.put(Items.CYAN_BANNER, BANNER);
        WATER.put(Items.GREEN_BANNER, BANNER);
        WATER.put(Items.LIGHT_BLUE_BANNER, BANNER);
        WATER.put(Items.LIGHT_GRAY_BANNER, BANNER);
        WATER.put(Items.LIME_BANNER, BANNER);
        WATER.put(Items.MAGENTA_BANNER, BANNER);
        WATER.put(Items.ORANGE_BANNER, BANNER);
        WATER.put(Items.PINK_BANNER, BANNER);
        WATER.put(Items.PURPLE_BANNER, BANNER);
        WATER.put(Items.RED_BANNER, BANNER);
        WATER.put(Items.YELLOW_BANNER, BANNER);
        WATER.put(Items.WHITE_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.GRAY_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.BLACK_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.BLUE_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.BROWN_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.CYAN_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.GREEN_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.LIGHT_BLUE_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.LIGHT_GRAY_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.LIME_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.MAGENTA_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.ORANGE_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.PINK_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.PURPLE_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.RED_SHULKER_BOX, SHULKER_BOX);
        WATER.put(Items.YELLOW_SHULKER_BOX, SHULKER_BOX);
        LAVA.put(Items.BUCKET, (var02, var1, var2, var3, var4, var5) -> CauldronInteraction.fillBucket(var02, var1, var2, var3, var4, var5, new ItemStack(Items.LAVA_BUCKET), var0 -> true, SoundEffects.BUCKET_FILL_LAVA));
        CauldronInteraction.addDefaultInteractions(LAVA);
        POWDER_SNOW.put(Items.BUCKET, (var02, var1, var2, var3, var4, var5) -> CauldronInteraction.fillBucket(var02, var1, var2, var3, var4, var5, new ItemStack(Items.POWDER_SNOW_BUCKET), var0 -> var0.getValue(LayeredCauldronBlock.LEVEL) == 3, SoundEffects.BUCKET_FILL_POWDER_SNOW));
        CauldronInteraction.addDefaultInteractions(POWDER_SNOW);
    }

    public static void addDefaultInteractions(Map<Item, CauldronInteraction> var0) {
        var0.put(Items.LAVA_BUCKET, FILL_LAVA);
        var0.put(Items.WATER_BUCKET, FILL_WATER);
        var0.put(Items.POWDER_SNOW_BUCKET, FILL_POWDER_SNOW);
    }

    public static EnumInteractionResult fillBucket(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, ItemStack var5, ItemStack var6, Predicate<IBlockData> var7, SoundEffect var8) {
        if (!var7.test(var0)) {
            return EnumInteractionResult.PASS;
        }
        if (!var1.isClientSide) {
            Item var9 = var5.getItem();
            var3.setItemInHand(var4, ItemLiquidUtil.createFilledResult(var5, var3, var6));
            var3.awardStat(StatisticList.USE_CAULDRON);
            var3.awardStat(StatisticList.ITEM_USED.get(var9));
            var1.setBlockAndUpdate(var2, Blocks.CAULDRON.defaultBlockState());
            var1.playSound(null, var2, var8, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var1.gameEvent(null, GameEvent.FLUID_PICKUP, var2);
        }
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    public static EnumInteractionResult emptyBucket(World var0, BlockPosition var1, EntityHuman var2, EnumHand var3, ItemStack var4, IBlockData var5, SoundEffect var6) {
        if (!var0.isClientSide) {
            Item var7 = var4.getItem();
            var2.setItemInHand(var3, ItemLiquidUtil.createFilledResult(var4, var2, new ItemStack(Items.BUCKET)));
            var2.awardStat(StatisticList.FILL_CAULDRON);
            var2.awardStat(StatisticList.ITEM_USED.get(var7));
            var0.setBlockAndUpdate(var1, var5);
            var0.playSound(null, var1, var6, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var0.gameEvent(null, GameEvent.FLUID_PLACE, var1);
        }
        return EnumInteractionResult.sidedSuccess(var0.isClientSide);
    }
}

