/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public interface IRegistryCustom {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> REGISTRIES = (Map)SystemUtils.make(() -> {
        ImmutableMap.Builder var0 = ImmutableMap.builder();
        IRegistryCustom.put(var0, IRegistry.DIMENSION_TYPE_REGISTRY, DimensionManager.DIRECT_CODEC, DimensionManager.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.BIOME_REGISTRY, BiomeBase.DIRECT_CODEC, BiomeBase.NETWORK_CODEC);
        IRegistryCustom.put(var0, IRegistry.CONFIGURED_CARVER_REGISTRY, WorldGenCarverWrapper.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.CONFIGURED_FEATURE_REGISTRY, WorldGenFeatureConfigured.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.PLACED_FEATURE_REGISTRY, PlacedFeature.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.STRUCTURE_REGISTRY, Structure.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.STRUCTURE_SET_REGISTRY, StructureSet.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.PROCESSOR_LIST_REGISTRY, DefinedStructureStructureProcessorType.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.TEMPLATE_POOL_REGISTRY, WorldGenFeatureDefinedStructurePoolTemplate.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.NOISE_GENERATOR_SETTINGS_REGISTRY, GeneratorSettingBase.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.NOISE_REGISTRY, NoiseGeneratorNormal.a.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.DENSITY_FUNCTION_REGISTRY, DensityFunction.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.CHAT_TYPE_REGISTRY, ChatMessageType.CODEC, ChatMessageType.CODEC);
        IRegistryCustom.put(var0, IRegistry.WORLD_PRESET_REGISTRY, WorldPreset.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.FLAT_LEVEL_GENERATOR_PRESET_REGISTRY, FlatLevelGeneratorPreset.DIRECT_CODEC);
        return var0.build();
    });
    public static final Codec<IRegistryCustom> NETWORK_CODEC = IRegistryCustom.makeNetworkCodec();
    public static final Supplier<Dimension> BUILTIN = Suppliers.memoize(() -> IRegistryCustom.builtinCopy().freeze());

    public <E> Optional<IRegistry<E>> ownedRegistry(ResourceKey<? extends IRegistry<? extends E>> var1);

    default public <E> IRegistry<E> ownedRegistryOrThrow(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.ownedRegistry(var0).orElseThrow(() -> new IllegalStateException("Missing registry: " + var0));
    }

    default public <E> Optional<? extends IRegistry<E>> registry(ResourceKey<? extends IRegistry<? extends E>> var0) {
        Optional<IRegistry<E>> var1 = this.ownedRegistry(var0);
        if (var1.isPresent()) {
            return var1;
        }
        return IRegistry.REGISTRY.getOptional(var0.location());
    }

    default public <E> IRegistry<E> registryOrThrow(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.registry(var0).orElseThrow(() -> new IllegalStateException("Missing registry: " + var0));
    }

    private static <E> void put(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> var0, ResourceKey<? extends IRegistry<E>> var1, Codec<E> var2) {
        var0.put(var1, new RegistryData<E>(var1, var2, null));
    }

    private static <E> void put(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> var0, ResourceKey<? extends IRegistry<E>> var1, Codec<E> var2, Codec<E> var3) {
        var0.put(var1, new RegistryData<E>(var1, var2, var3));
    }

    public static Iterable<RegistryData<?>> knownRegistries() {
        return REGISTRIES.values();
    }

    public Stream<d<?>> ownedRegistries();

    private static Stream<d<Object>> globalRegistries() {
        return IRegistry.REGISTRY.holders().map(d::fromHolder);
    }

    default public Stream<d<?>> registries() {
        return Stream.concat(this.ownedRegistries(), IRegistryCustom.globalRegistries());
    }

    default public Stream<d<?>> networkSafeRegistries() {
        return Stream.concat(this.ownedNetworkableRegistries(), IRegistryCustom.globalRegistries());
    }

    private static <E> Codec<IRegistryCustom> makeNetworkCodec() {
        Codec var02 = MinecraftKey.CODEC.xmap(ResourceKey::createRegistryKey, ResourceKey::location);
        Codec var1 = var02.partialDispatch("type", var0 -> DataResult.success(var0.key()), var0 -> IRegistryCustom.getNetworkCodec(var0).map(var1 -> RegistryCodecs.networkCodec(var0, Lifecycle.experimental(), var1)));
        UnboundedMapCodec var2 = Codec.unboundedMap((Codec)var02, (Codec)var1);
        return IRegistryCustom.captureMap(var2);
    }

    private static <K extends ResourceKey<? extends IRegistry<?>>, V extends IRegistry<?>> Codec<IRegistryCustom> captureMap(UnboundedMapCodec<K, V> var0) {
        return var0.xmap(b::new, var02 -> (Map)var02.ownedNetworkableRegistries().collect(ImmutableMap.toImmutableMap(var0 -> var0.key(), var0 -> var0.value())));
    }

    private Stream<d<?>> ownedNetworkableRegistries() {
        return this.ownedRegistries().filter(var0 -> REGISTRIES.get(var0.key).sendToClient());
    }

    private static <E> DataResult<? extends Codec<E>> getNetworkCodec(ResourceKey<? extends IRegistry<E>> var02) {
        return Optional.ofNullable(REGISTRIES.get(var02)).map(var0 -> var0.networkCodec()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + var02)));
    }

    private static Map<ResourceKey<? extends IRegistry<?>>, ? extends IRegistryWritable<?>> createFreshRegistries() {
        return REGISTRIES.keySet().stream().collect(Collectors.toMap(Function.identity(), IRegistryCustom::createRegistry));
    }

    private static e blankWriteable() {
        return new f(IRegistryCustom.createFreshRegistries());
    }

    public static Dimension fromRegistryOfRegistries(final IRegistry<? extends IRegistry<?>> var0) {
        return new Dimension(){

            public <T> Optional<IRegistry<T>> ownedRegistry(ResourceKey<? extends IRegistry<? extends T>> var02) {
                IRegistry var1 = var0;
                return var1.getOptional(var02);
            }

            @Override
            public Stream<d<?>> ownedRegistries() {
                return var0.entrySet().stream().map(d::fromMapEntry);
            }
        };
    }

    public static e builtinCopy() {
        e var0 = IRegistryCustom.blankWriteable();
        RegistryResourceAccess.InMemoryStorage var1 = new RegistryResourceAccess.InMemoryStorage();
        for (Map.Entry<ResourceKey<IRegistry<?>>, RegistryData<?>> var3 : REGISTRIES.entrySet()) {
            IRegistryCustom.addBuiltinElements(var1, var3.getValue());
        }
        RegistryOps.createAndLoad(JsonOps.INSTANCE, var0, var1);
        return var0;
    }

    private static <E> void addBuiltinElements(RegistryResourceAccess.InMemoryStorage var0, RegistryData<E> var1) {
        ResourceKey<IRegistry<E>> var2 = var1.key();
        IRegistry<E> var3 = RegistryGeneration.ACCESS.registryOrThrow(var2);
        for (Map.Entry<ResourceKey<E>, E> var5 : var3.entrySet()) {
            ResourceKey<E> var6 = var5.getKey();
            E var7 = var5.getValue();
            var0.add(RegistryGeneration.ACCESS, var6, var1.codec(), var3.getId(var7), var7, var3.lifecycle(var7));
        }
    }

    public static void load(e var0, DynamicOps<JsonElement> var1, RegistryLoader var2) {
        RegistryLoader.a var3 = var2.bind(var0);
        for (RegistryData<?> var5 : REGISTRIES.values()) {
            IRegistryCustom.readRegistry(var1, var3, var5);
        }
    }

    private static <E> void readRegistry(DynamicOps<JsonElement> var02, RegistryLoader.a var1, RegistryData<E> var2) {
        DataResult<IRegistry<E>> var3 = var1.overrideRegistryFromResources(var2.key(), var2.codec(), var02);
        var3.error().ifPresent(var0 -> {
            throw new JsonParseException("Error loading registry data: " + var0.message());
        });
    }

    public static IRegistryCustom readFromDisk(Dynamic<?> var0) {
        return new b(REGISTRIES.keySet().stream().collect(Collectors.toMap(Function.identity(), var1 -> IRegistryCustom.retrieveRegistry(var1, var0))));
    }

    public static <E> IRegistry<E> retrieveRegistry(ResourceKey<? extends IRegistry<? extends E>> var0, Dynamic<?> var1) {
        return (IRegistry)RegistryOps.retrieveRegistry(var0).codec().parse(var1).resultOrPartial(SystemUtils.prefix(var0 + " registry: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get " + var0 + " registry"));
    }

    public static <E> IRegistryWritable<?> createRegistry(ResourceKey<? extends IRegistry<?>> var0) {
        return new RegistryMaterials(var0, Lifecycle.stable(), null);
    }

    default public Dimension freeze() {
        return new b(this.ownedRegistries().map(d::freeze));
    }

    default public Lifecycle allElementsLifecycle() {
        return this.ownedRegistries().map(var0 -> var0.value.elementsLifecycle()).reduce(Lifecycle.stable(), Lifecycle::add);
    }

    public record RegistryData<E>(ResourceKey<? extends IRegistry<E>> key, Codec<E> codec, @Nullable Codec<E> networkCodec) {
        public boolean sendToClient() {
            return this.networkCodec != null;
        }
    }

    public static final class f
    implements e {
        private final Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistryWritable<?>> registries;

        f(Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistryWritable<?>> var0) {
            this.registries = var0;
        }

        @Override
        public <E> Optional<IRegistry<E>> ownedRegistry(ResourceKey<? extends IRegistry<? extends E>> var02) {
            return Optional.ofNullable(this.registries.get(var02)).map(var0 -> var0);
        }

        @Override
        public <E> Optional<IRegistryWritable<E>> ownedWritableRegistry(ResourceKey<? extends IRegistry<? extends E>> var02) {
            return Optional.ofNullable(this.registries.get(var02)).map(var0 -> var0);
        }

        @Override
        public Stream<d<?>> ownedRegistries() {
            return this.registries.entrySet().stream().map(d::fromMapEntry);
        }
    }

    public static interface e
    extends IRegistryCustom {
        public <E> Optional<IRegistryWritable<E>> ownedWritableRegistry(ResourceKey<? extends IRegistry<? extends E>> var1);

        default public <E> IRegistryWritable<E> ownedWritableRegistryOrThrow(ResourceKey<? extends IRegistry<? extends E>> var0) {
            return this.ownedWritableRegistry(var0).orElseThrow(() -> new IllegalStateException("Missing registry: " + var0));
        }
    }

    public static final class b
    implements Dimension {
        private final Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistry<?>> registries;

        public b(Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistry<?>> var0) {
            this.registries = Map.copyOf(var0);
        }

        b(Stream<d<?>> var0) {
            this.registries = (Map)var0.collect(ImmutableMap.toImmutableMap(d::key, d::value));
        }

        @Override
        public <E> Optional<IRegistry<E>> ownedRegistry(ResourceKey<? extends IRegistry<? extends E>> var02) {
            return Optional.ofNullable(this.registries.get(var02)).map(var0 -> var0);
        }

        @Override
        public Stream<d<?>> ownedRegistries() {
            return this.registries.entrySet().stream().map(d::fromMapEntry);
        }
    }

    public static final class d<T>
    extends Record {
        final ResourceKey<? extends IRegistry<T>> key;
        final IRegistry<T> value;

        public d(ResourceKey<? extends IRegistry<T>> var0, IRegistry<T> var1) {
            this.key = var0;
            this.value = var1;
        }

        private static <T, R extends IRegistry<? extends T>> d<T> fromMapEntry(Map.Entry<? extends ResourceKey<? extends IRegistry<?>>, R> var0) {
            return d.fromUntyped(var0.getKey(), (IRegistry)var0.getValue());
        }

        private static <T> d<T> fromHolder(Holder.c<? extends IRegistry<? extends T>> var0) {
            return d.fromUntyped(var0.key(), var0.value());
        }

        private static <T> d<T> fromUntyped(ResourceKey<? extends IRegistry<?>> var0, IRegistry<?> var1) {
            return new d(var0, var1);
        }

        private d<T> freeze() {
            return new d<T>(this.key, this.value.freeze());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "key;value", "key", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "key;value", "key", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "key;value", "key", "value"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<T>> key() {
            return this.key;
        }

        public IRegistry<T> value() {
            return this.value;
        }
    }

    public static interface Dimension
    extends IRegistryCustom {
        @Override
        default public Dimension freeze() {
            return this;
        }
    }
}

