/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public interface HolderLookup<T> {
    public Optional<Holder<T>> get(ResourceKey<T> var1);

    public Stream<ResourceKey<T>> listElements();

    public Optional<? extends HolderSet<T>> get(TagKey<T> var1);

    public Stream<TagKey<T>> listTags();

    public static <T> HolderLookup<T> forRegistry(IRegistry<T> var0) {
        return new a<T>(var0);
    }

    public static class a<T>
    implements HolderLookup<T> {
        protected final IRegistry<T> registry;

        public a(IRegistry<T> var0) {
            this.registry = var0;
        }

        @Override
        public Optional<Holder<T>> get(ResourceKey<T> var0) {
            return this.registry.getHolder(var0);
        }

        @Override
        public Stream<ResourceKey<T>> listElements() {
            return this.registry.entrySet().stream().map(Map.Entry::getKey);
        }

        @Override
        public Optional<? extends HolderSet<T>> get(TagKey<T> var0) {
            return this.registry.getTag(var0);
        }

        @Override
        public Stream<TagKey<T>> listTags() {
            return this.registry.getTagNames();
        }
    }
}

