/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import net.minecraft.core.EnumDirection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class EnumAxisCycle
extends Enum<EnumAxisCycle> {
    public static final /* enum */ EnumAxisCycle NONE = new EnumAxisCycle(){

        @Override
        public int cycle(int var0, int var1, int var2, EnumDirection.EnumAxis var3) {
            return var3.choose(var0, var1, var2);
        }

        @Override
        public double cycle(double var0, double var2, double var4, EnumDirection.EnumAxis var6) {
            return var6.choose(var0, var2, var4);
        }

        @Override
        public EnumDirection.EnumAxis cycle(EnumDirection.EnumAxis var0) {
            return var0;
        }

        @Override
        public EnumAxisCycle inverse() {
            return this;
        }
    };
    public static final /* enum */ EnumAxisCycle FORWARD = new EnumAxisCycle(){

        @Override
        public int cycle(int var0, int var1, int var2, EnumDirection.EnumAxis var3) {
            return var3.choose(var2, var0, var1);
        }

        @Override
        public double cycle(double var0, double var2, double var4, EnumDirection.EnumAxis var6) {
            return var6.choose(var4, var0, var2);
        }

        @Override
        public EnumDirection.EnumAxis cycle(EnumDirection.EnumAxis var0) {
            return AXIS_VALUES[Math.floorMod(var0.ordinal() + 1, 3)];
        }

        @Override
        public EnumAxisCycle inverse() {
            return BACKWARD;
        }
    };
    public static final /* enum */ EnumAxisCycle BACKWARD = new EnumAxisCycle(){

        @Override
        public int cycle(int var0, int var1, int var2, EnumDirection.EnumAxis var3) {
            return var3.choose(var1, var2, var0);
        }

        @Override
        public double cycle(double var0, double var2, double var4, EnumDirection.EnumAxis var6) {
            return var6.choose(var2, var4, var0);
        }

        @Override
        public EnumDirection.EnumAxis cycle(EnumDirection.EnumAxis var0) {
            return AXIS_VALUES[Math.floorMod(var0.ordinal() - 1, 3)];
        }

        @Override
        public EnumAxisCycle inverse() {
            return FORWARD;
        }
    };
    public static final EnumDirection.EnumAxis[] AXIS_VALUES;
    public static final EnumAxisCycle[] VALUES;
    private static final /* synthetic */ EnumAxisCycle[] f;

    public static EnumAxisCycle[] values() {
        return (EnumAxisCycle[])f.clone();
    }

    public static EnumAxisCycle valueOf(String var0) {
        return Enum.valueOf(EnumAxisCycle.class, var0);
    }

    public abstract int cycle(int var1, int var2, int var3, EnumDirection.EnumAxis var4);

    public abstract double cycle(double var1, double var3, double var5, EnumDirection.EnumAxis var7);

    public abstract EnumDirection.EnumAxis cycle(EnumDirection.EnumAxis var1);

    public abstract EnumAxisCycle inverse();

    public static EnumAxisCycle between(EnumDirection.EnumAxis var0, EnumDirection.EnumAxis var1) {
        return VALUES[Math.floorMod(var1.ordinal() - var0.ordinal(), 3)];
    }

    private static /* synthetic */ EnumAxisCycle[] b() {
        return new EnumAxisCycle[]{NONE, FORWARD, BACKWARD};
    }

    static {
        f = EnumAxisCycle.b();
        AXIS_VALUES = EnumDirection.EnumAxis.values();
        VALUES = EnumAxisCycle.values();
    }
}

