/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.PreviewedArgument;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PreviewableCommand;

public record ArgumentSignatures(List<a> entries) {
    public static final ArgumentSignatures EMPTY = new ArgumentSignatures(List.of());
    private static final int MAX_ARGUMENT_COUNT = 8;
    private static final int MAX_ARGUMENT_NAME_LENGTH = 16;

    public ArgumentSignatures(PacketDataSerializer var0) {
        this(var0.readCollection(PacketDataSerializer.limitValue(ArrayList::new, 8), a::new));
    }

    public MessageSignature get(String var0) {
        for (a var2 : this.entries) {
            if (!var2.name.equals(var0)) continue;
            return var2.signature;
        }
        return MessageSignature.EMPTY;
    }

    public void write(PacketDataSerializer var02) {
        var02.writeCollection(this.entries, (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
    }

    public static boolean hasSignableArguments(PreviewableCommand<?> var02) {
        return var02.arguments().stream().anyMatch(var0 -> var0.previewType() instanceof SignedArgument);
    }

    public static ArgumentSignatures signCommand(PreviewableCommand<?> var0, b var12) {
        List<a> var2 = ArgumentSignatures.collectPlainSignableArguments(var0).stream().map(var1 -> {
            MessageSignature var2 = var12.sign((String)var1.getFirst(), (String)var1.getSecond());
            return new a((String)var1.getFirst(), var2);
        }).toList();
        return new ArgumentSignatures(var2);
    }

    public static List<Pair<String, String>> collectPlainSignableArguments(PreviewableCommand<?> var0) {
        ArrayList<Pair<String, String>> var1 = new ArrayList<Pair<String, String>>();
        for (PreviewableCommand.a<?> var3 : var0.arguments()) {
            PreviewedArgument<?> previewedArgument = var3.previewType();
            if (!(previewedArgument instanceof SignedArgument)) continue;
            SignedArgument var4 = (SignedArgument)previewedArgument;
            String var5 = ArgumentSignatures.getSignableText(var4, var3.parsedValue());
            var1.add((Pair<String, String>)Pair.of((Object)var3.name(), (Object)var5));
        }
        return var1;
    }

    private static <T> String getSignableText(SignedArgument<T> var0, ParsedArgument<?, ?> var1) {
        return var0.getSignableText(var1.getResult());
    }

    public static final class a
    extends Record {
        final String name;
        final MessageSignature signature;

        public a(PacketDataSerializer var0) {
            this(var0.readUtf(16), new MessageSignature(var0));
        }

        public a(String var0, MessageSignature var1) {
            this.name = var0;
            this.signature = var1;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeUtf(this.name, 16);
            this.signature.write(var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;signature", "name", "signature"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;signature", "name", "signature"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;signature", "name", "signature"}, this, var0);
        }

        public String name() {
            return this.name;
        }

        public MessageSignature signature() {
            return this.signature;
        }
    }

    @FunctionalInterface
    public static interface b {
        public MessageSignature sign(String var1, String var2);
    }
}

