/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.effect.MobEffectList;

public class ArgumentMobEffect
implements ArgumentType<MobEffectList> {
    private static final Collection<String> EXAMPLES = Arrays.asList("spooky", "effect");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_EFFECT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("effect.effectNotFound", var0));

    public static ArgumentMobEffect effect() {
        return new ArgumentMobEffect();
    }

    public static MobEffectList getEffect(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (MobEffectList)var0.getArgument(var1, MobEffectList.class);
    }

    public MobEffectList parse(StringReader var0) throws CommandSyntaxException {
        MinecraftKey var1 = MinecraftKey.read(var0);
        return IRegistry.MOB_EFFECT.getOptional(var1).orElseThrow(() -> ERROR_UNKNOWN_EFFECT.create((Object)var1));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.suggestResource(IRegistry.MOB_EFFECT.keySet(), var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

