/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class LightningStrikeTrigger
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("lightning_strike");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    public a createInstance(JsonObject var0, CriterionConditionEntity.b var1, LootDeserializationContext var2) {
        CriterionConditionEntity.b var3 = CriterionConditionEntity.b.fromJson(var0, "lightning", var2);
        CriterionConditionEntity.b var4 = CriterionConditionEntity.b.fromJson(var0, "bystander", var2);
        return new a(var1, var3, var4);
    }

    public void trigger(EntityPlayer var0, EntityLightning var12, List<Entity> var22) {
        List var3 = var22.stream().map(var1 -> CriterionConditionEntity.createContext(var0, var1)).collect(Collectors.toList());
        LootTableInfo var4 = CriterionConditionEntity.createContext(var0, var12);
        this.trigger(var0, var2 -> var2.matches(var4, var3));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, CriterionConditionEntity.b b2, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, b2, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final CriterionConditionEntity.b lightning;
        private final CriterionConditionEntity.b bystander;

        public a(CriterionConditionEntity.b var0, CriterionConditionEntity.b var1, CriterionConditionEntity.b var2) {
            super(ID, var0);
            this.lightning = var1;
            this.bystander = var2;
        }

        public static a lighthingStrike(CriterionConditionEntity var0, CriterionConditionEntity var1) {
            return new a(CriterionConditionEntity.b.ANY, CriterionConditionEntity.b.wrap(var0), CriterionConditionEntity.b.wrap(var1));
        }

        public boolean matches(LootTableInfo var0, List<LootTableInfo> var1) {
            if (!this.lightning.matches(var0)) {
                return false;
            }
            if (this.bystander != CriterionConditionEntity.b.ANY) {
                if (var1.stream().noneMatch(this.bystander::matches)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            var1.add("lightning", this.lightning.toJson(var0));
            var1.add("bystander", this.bystander.toJson(var0));
            return var1;
        }
    }
}

