/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public class EntityVariantPredicate<V> {
    private static final String VARIANT_KEY = "variant";
    final IRegistry<V> registry;
    final Function<Entity, Optional<V>> getter;
    final EntitySubPredicate.a type;

    public static <V> EntityVariantPredicate<V> create(IRegistry<V> var0, Function<Entity, Optional<V>> var1) {
        return new EntityVariantPredicate<V>(var0, var1);
    }

    private EntityVariantPredicate(IRegistry<V> var0, Function<Entity, Optional<V>> var12) {
        this.registry = var0;
        this.getter = var12;
        this.type = var1 -> {
            String var2 = ChatDeserializer.getAsString(var1, VARIANT_KEY);
            Object var3 = var0.get(MinecraftKey.tryParse(var2));
            if (var3 == null) {
                throw new JsonSyntaxException("Unknown variant: " + var2);
            }
            return this.createPredicate(var3);
        };
    }

    public EntitySubPredicate.a type() {
        return this.type;
    }

    public EntitySubPredicate createPredicate(final V var0) {
        return new EntitySubPredicate(){

            @Override
            public boolean matches(Entity var02, WorldServer var12, @Nullable Vec3D var2) {
                return EntityVariantPredicate.this.getter.apply(var02).filter(var1 -> var1.equals(var0)).isPresent();
            }

            @Override
            public JsonObject serializeCustomData() {
                JsonObject var02 = new JsonObject();
                var02.addProperty(EntityVariantPredicate.VARIANT_KEY, EntityVariantPredicate.this.registry.getKey(var0).toString());
                return var02;
            }

            @Override
            public EntitySubPredicate.a type() {
                return EntityVariantPredicate.this.type;
            }
        };
    }
}

