/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;

public class CriterionConditionNBT {
    public static final CriterionConditionNBT ANY = new CriterionConditionNBT(null);
    @Nullable
    private final NBTTagCompound tag;

    public CriterionConditionNBT(@Nullable NBTTagCompound var0) {
        this.tag = var0;
    }

    public boolean matches(ItemStack var0) {
        if (this == ANY) {
            return true;
        }
        return this.matches(var0.getTag());
    }

    public boolean matches(Entity var0) {
        if (this == ANY) {
            return true;
        }
        return this.matches(CriterionConditionNBT.getEntityTagToCompare(var0));
    }

    public boolean matches(@Nullable NBTBase var0) {
        if (var0 == null) {
            return this == ANY;
        }
        return this.tag == null || GameProfileSerializer.compareNbt(this.tag, var0, true);
    }

    public JsonElement serializeToJson() {
        if (this == ANY || this.tag == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.tag.toString());
    }

    public static CriterionConditionNBT fromJson(@Nullable JsonElement var0) {
        NBTTagCompound var1;
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        try {
            var1 = MojangsonParser.parseTag(ChatDeserializer.convertToString(var0, "nbt"));
        }
        catch (CommandSyntaxException var2) {
            throw new JsonSyntaxException("Invalid nbt tag: " + var2.getMessage());
        }
        return new CriterionConditionNBT(var1);
    }

    public static NBTTagCompound getEntityTagToCompare(Entity var0) {
        ItemStack var2;
        NBTTagCompound var1 = var0.saveWithoutId(new NBTTagCompound());
        if (var0 instanceof EntityHuman && !(var2 = ((EntityHuman)var0).getInventory().getSelected()).isEmpty()) {
            var1.put("SelectedItem", var2.save(new NBTTagCompound()));
        }
        return var1;
    }
}

