/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionDistance;
import net.minecraft.advancements.critereon.CriterionConditionEntityEquipment;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionEntityType;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionConditionMobEffect;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeamBase;

public class CriterionConditionEntity {
    public static final CriterionConditionEntity ANY = new CriterionConditionEntity(CriterionConditionEntityType.ANY, CriterionConditionDistance.ANY, CriterionConditionLocation.ANY, CriterionConditionLocation.ANY, CriterionConditionMobEffect.ANY, CriterionConditionNBT.ANY, CriterionConditionEntityFlags.ANY, CriterionConditionEntityEquipment.ANY, EntitySubPredicate.ANY, null);
    private final CriterionConditionEntityType entityType;
    private final CriterionConditionDistance distanceToPlayer;
    private final CriterionConditionLocation location;
    private final CriterionConditionLocation steppingOnLocation;
    private final CriterionConditionMobEffect effects;
    private final CriterionConditionNBT nbt;
    private final CriterionConditionEntityFlags flags;
    private final CriterionConditionEntityEquipment equipment;
    private final EntitySubPredicate subPredicate;
    private final CriterionConditionEntity vehicle;
    private final CriterionConditionEntity passenger;
    private final CriterionConditionEntity targetedEntity;
    @Nullable
    private final String team;

    private CriterionConditionEntity(CriterionConditionEntityType var0, CriterionConditionDistance var1, CriterionConditionLocation var2, CriterionConditionLocation var3, CriterionConditionMobEffect var4, CriterionConditionNBT var5, CriterionConditionEntityFlags var6, CriterionConditionEntityEquipment var7, EntitySubPredicate var8, @Nullable String var9) {
        this.entityType = var0;
        this.distanceToPlayer = var1;
        this.location = var2;
        this.steppingOnLocation = var3;
        this.effects = var4;
        this.nbt = var5;
        this.flags = var6;
        this.equipment = var7;
        this.subPredicate = var8;
        this.passenger = this;
        this.vehicle = this;
        this.targetedEntity = this;
        this.team = var9;
    }

    CriterionConditionEntity(CriterionConditionEntityType var0, CriterionConditionDistance var1, CriterionConditionLocation var2, CriterionConditionLocation var3, CriterionConditionMobEffect var4, CriterionConditionNBT var5, CriterionConditionEntityFlags var6, CriterionConditionEntityEquipment var7, EntitySubPredicate var8, CriterionConditionEntity var9, CriterionConditionEntity var10, CriterionConditionEntity var11, @Nullable String var12) {
        this.entityType = var0;
        this.distanceToPlayer = var1;
        this.location = var2;
        this.steppingOnLocation = var3;
        this.effects = var4;
        this.nbt = var5;
        this.flags = var6;
        this.equipment = var7;
        this.subPredicate = var8;
        this.vehicle = var9;
        this.passenger = var10;
        this.targetedEntity = var11;
        this.team = var12;
    }

    public boolean matches(EntityPlayer var0, @Nullable Entity var1) {
        return this.matches(var0.getLevel(), var0.position(), var1);
    }

    public boolean matches(WorldServer var0, @Nullable Vec3D var1, @Nullable Entity var22) {
        Object var3;
        if (this == ANY) {
            return true;
        }
        if (var22 == null) {
            return false;
        }
        if (!this.entityType.matches(var22.getType())) {
            return false;
        }
        if (var1 == null ? this.distanceToPlayer != CriterionConditionDistance.ANY : !this.distanceToPlayer.matches(var1.x, var1.y, var1.z, var22.getX(), var22.getY(), var22.getZ())) {
            return false;
        }
        if (!this.location.matches(var0, var22.getX(), var22.getY(), var22.getZ())) {
            return false;
        }
        if (this.steppingOnLocation != CriterionConditionLocation.ANY && !this.steppingOnLocation.matches(var0, ((Vec3D)(var3 = Vec3D.atCenterOf(var22.getOnPosLegacy()))).x(), ((Vec3D)var3).y(), ((Vec3D)var3).z())) {
            return false;
        }
        if (!this.effects.matches(var22)) {
            return false;
        }
        if (!this.nbt.matches(var22)) {
            return false;
        }
        if (!this.flags.matches(var22)) {
            return false;
        }
        if (!this.equipment.matches(var22)) {
            return false;
        }
        if (!this.subPredicate.matches(var22, var0, var1)) {
            return false;
        }
        if (!this.vehicle.matches(var0, var1, var22.getVehicle())) {
            return false;
        }
        if (this.passenger != ANY && var22.getPassengers().stream().noneMatch(var2 -> this.passenger.matches(var0, var1, (Entity)var2))) {
            return false;
        }
        if (!this.targetedEntity.matches(var0, var1, var22 instanceof EntityInsentient ? ((EntityInsentient)var22).getTarget() : null)) {
            return false;
        }
        return this.team == null || (var3 = var22.getTeam()) != null && this.team.equals(((ScoreboardTeamBase)var3).getName());
    }

    public static CriterionConditionEntity fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "entity");
        CriterionConditionEntityType var2 = CriterionConditionEntityType.fromJson(var1.get("type"));
        CriterionConditionDistance var3 = CriterionConditionDistance.fromJson(var1.get("distance"));
        CriterionConditionLocation var4 = CriterionConditionLocation.fromJson(var1.get("location"));
        CriterionConditionLocation var5 = CriterionConditionLocation.fromJson(var1.get("stepping_on"));
        CriterionConditionMobEffect var6 = CriterionConditionMobEffect.fromJson(var1.get("effects"));
        CriterionConditionNBT var7 = CriterionConditionNBT.fromJson(var1.get("nbt"));
        CriterionConditionEntityFlags var8 = CriterionConditionEntityFlags.fromJson(var1.get("flags"));
        CriterionConditionEntityEquipment var9 = CriterionConditionEntityEquipment.fromJson(var1.get("equipment"));
        EntitySubPredicate var10 = EntitySubPredicate.fromJson(var1.get("type_specific"));
        CriterionConditionEntity var11 = CriterionConditionEntity.fromJson(var1.get("vehicle"));
        CriterionConditionEntity var12 = CriterionConditionEntity.fromJson(var1.get("passenger"));
        CriterionConditionEntity var13 = CriterionConditionEntity.fromJson(var1.get("targeted_entity"));
        String var14 = ChatDeserializer.getAsString(var1, "team", null);
        return new a().entityType(var2).distance(var3).located(var4).steppingOn(var5).effects(var6).nbt(var7).flags(var8).equipment(var9).subPredicate(var10).team(var14).vehicle(var11).passenger(var12).targetedEntity(var13).build();
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        var0.add("type", this.entityType.serializeToJson());
        var0.add("distance", this.distanceToPlayer.serializeToJson());
        var0.add("location", this.location.serializeToJson());
        var0.add("stepping_on", this.steppingOnLocation.serializeToJson());
        var0.add("effects", this.effects.serializeToJson());
        var0.add("nbt", this.nbt.serializeToJson());
        var0.add("flags", this.flags.serializeToJson());
        var0.add("equipment", this.equipment.serializeToJson());
        var0.add("type_specific", this.subPredicate.serialize());
        var0.add("vehicle", this.vehicle.serializeToJson());
        var0.add("passenger", this.passenger.serializeToJson());
        var0.add("targeted_entity", this.targetedEntity.serializeToJson());
        var0.addProperty("team", this.team);
        return var0;
    }

    public static LootTableInfo createContext(EntityPlayer var0, Entity var1) {
        return new LootTableInfo.Builder(var0.getLevel()).withParameter(LootContextParameters.THIS_ENTITY, var1).withParameter(LootContextParameters.ORIGIN, var0.position()).withRandom(var0.getRandom()).create(LootContextParameterSets.ADVANCEMENT_ENTITY);
    }

    public static class a {
        private CriterionConditionEntityType entityType = CriterionConditionEntityType.ANY;
        private CriterionConditionDistance distanceToPlayer = CriterionConditionDistance.ANY;
        private CriterionConditionLocation location = CriterionConditionLocation.ANY;
        private CriterionConditionLocation steppingOnLocation = CriterionConditionLocation.ANY;
        private CriterionConditionMobEffect effects = CriterionConditionMobEffect.ANY;
        private CriterionConditionNBT nbt = CriterionConditionNBT.ANY;
        private CriterionConditionEntityFlags flags = CriterionConditionEntityFlags.ANY;
        private CriterionConditionEntityEquipment equipment = CriterionConditionEntityEquipment.ANY;
        private EntitySubPredicate subPredicate = EntitySubPredicate.ANY;
        private CriterionConditionEntity vehicle = ANY;
        private CriterionConditionEntity passenger = ANY;
        private CriterionConditionEntity targetedEntity = ANY;
        @Nullable
        private String team;

        public static a entity() {
            return new a();
        }

        public a of(EntityTypes<?> var0) {
            this.entityType = CriterionConditionEntityType.of(var0);
            return this;
        }

        public a of(TagKey<EntityTypes<?>> var0) {
            this.entityType = CriterionConditionEntityType.of(var0);
            return this;
        }

        public a entityType(CriterionConditionEntityType var0) {
            this.entityType = var0;
            return this;
        }

        public a distance(CriterionConditionDistance var0) {
            this.distanceToPlayer = var0;
            return this;
        }

        public a located(CriterionConditionLocation var0) {
            this.location = var0;
            return this;
        }

        public a steppingOn(CriterionConditionLocation var0) {
            this.steppingOnLocation = var0;
            return this;
        }

        public a effects(CriterionConditionMobEffect var0) {
            this.effects = var0;
            return this;
        }

        public a nbt(CriterionConditionNBT var0) {
            this.nbt = var0;
            return this;
        }

        public a flags(CriterionConditionEntityFlags var0) {
            this.flags = var0;
            return this;
        }

        public a equipment(CriterionConditionEntityEquipment var0) {
            this.equipment = var0;
            return this;
        }

        public a subPredicate(EntitySubPredicate var0) {
            this.subPredicate = var0;
            return this;
        }

        public a vehicle(CriterionConditionEntity var0) {
            this.vehicle = var0;
            return this;
        }

        public a passenger(CriterionConditionEntity var0) {
            this.passenger = var0;
            return this;
        }

        public a targetedEntity(CriterionConditionEntity var0) {
            this.targetedEntity = var0;
            return this;
        }

        public a team(@Nullable String var0) {
            this.team = var0;
            return this;
        }

        public CriterionConditionEntity build() {
            return new CriterionConditionEntity(this.entityType, this.distanceToPlayer, this.location, this.steppingOnLocation, this.effects, this.nbt, this.flags, this.equipment, this.subPredicate, this.vehicle, this.passenger, this.targetedEntity, this.team);
        }
    }

    public static class b {
        public static final b ANY = new b(new LootItemCondition[0]);
        private final LootItemCondition[] conditions;
        private final Predicate<LootTableInfo> compositePredicates;

        private b(LootItemCondition[] var0) {
            this.conditions = var0;
            this.compositePredicates = LootItemConditions.andConditions(var0);
        }

        public static b create(LootItemCondition ... var0) {
            return new b(var0);
        }

        public static b fromJson(JsonObject var0, String var1, LootDeserializationContext var2) {
            JsonElement var3 = var0.get(var1);
            return b.fromElement(var1, var2, var3);
        }

        public static b[] fromJsonArray(JsonObject var0, String var1, LootDeserializationContext var2) {
            JsonElement var3 = var0.get(var1);
            if (var3 == null || var3.isJsonNull()) {
                return new b[0];
            }
            JsonArray var4 = ChatDeserializer.convertToJsonArray(var3, var1);
            b[] var5 = new b[var4.size()];
            for (int var6 = 0; var6 < var4.size(); ++var6) {
                var5[var6] = b.fromElement(var1 + "[" + var6 + "]", var2, var4.get(var6));
            }
            return var5;
        }

        private static b fromElement(String var0, LootDeserializationContext var1, @Nullable JsonElement var2) {
            if (var2 != null && var2.isJsonArray()) {
                LootItemCondition[] var3 = var1.deserializeConditions(var2.getAsJsonArray(), var1.getAdvancementId() + "/" + var0, LootContextParameterSets.ADVANCEMENT_ENTITY);
                return new b(var3);
            }
            CriterionConditionEntity var3 = CriterionConditionEntity.fromJson(var2);
            return b.wrap(var3);
        }

        public static b wrap(CriterionConditionEntity var0) {
            if (var0 == ANY) {
                return ANY;
            }
            LootItemCondition var1 = LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, var0).build();
            return new b(new LootItemCondition[]{var1});
        }

        public boolean matches(LootTableInfo var0) {
            return this.compositePredicates.test(var0);
        }

        public JsonElement toJson(LootSerializationContext var0) {
            if (this.conditions.length == 0) {
                return JsonNull.INSTANCE;
            }
            return var0.serializeConditions(this.conditions);
        }

        public static JsonElement toJson(b[] var0, LootSerializationContext var1) {
            if (var0.length == 0) {
                return JsonNull.INSTANCE;
            }
            JsonArray var2 = new JsonArray();
            for (b var6 : var0) {
                var2.add(var6.toJson(var1));
            }
            return var2;
        }
    }
}

