/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.Vector3fa;
import net.minecraft.util.MathHelper;

public final class Quaternion {
    public static final Quaternion ONE = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private float i;
    private float j;
    private float k;
    private float r;

    public Quaternion(float var0, float var1, float var2, float var3) {
        this.i = var0;
        this.j = var1;
        this.k = var2;
        this.r = var3;
    }

    public Quaternion(Vector3fa var0, float var1, boolean var2) {
        if (var2) {
            var1 *= (float)Math.PI / 180;
        }
        float var3 = Quaternion.sin(var1 / 2.0f);
        this.i = var0.x() * var3;
        this.j = var0.y() * var3;
        this.k = var0.z() * var3;
        this.r = Quaternion.cos(var1 / 2.0f);
    }

    public Quaternion(float var0, float var1, float var2, boolean var3) {
        if (var3) {
            var0 *= (float)Math.PI / 180;
            var1 *= (float)Math.PI / 180;
            var2 *= (float)Math.PI / 180;
        }
        float var4 = Quaternion.sin(0.5f * var0);
        float var5 = Quaternion.cos(0.5f * var0);
        float var6 = Quaternion.sin(0.5f * var1);
        float var7 = Quaternion.cos(0.5f * var1);
        float var8 = Quaternion.sin(0.5f * var2);
        float var9 = Quaternion.cos(0.5f * var2);
        this.i = var4 * var7 * var9 + var5 * var6 * var8;
        this.j = var5 * var6 * var9 - var4 * var7 * var8;
        this.k = var4 * var6 * var9 + var5 * var7 * var8;
        this.r = var5 * var7 * var9 - var4 * var6 * var8;
    }

    public Quaternion(Quaternion var0) {
        this.i = var0.i;
        this.j = var0.j;
        this.k = var0.k;
        this.r = var0.r;
    }

    public static Quaternion fromYXZ(float var0, float var1, float var2) {
        Quaternion var3 = ONE.copy();
        var3.mul(new Quaternion(0.0f, (float)Math.sin(var0 / 2.0f), 0.0f, (float)Math.cos(var0 / 2.0f)));
        var3.mul(new Quaternion((float)Math.sin(var1 / 2.0f), 0.0f, 0.0f, (float)Math.cos(var1 / 2.0f)));
        var3.mul(new Quaternion(0.0f, 0.0f, (float)Math.sin(var2 / 2.0f), (float)Math.cos(var2 / 2.0f)));
        return var3;
    }

    public static Quaternion fromXYZDegrees(Vector3fa var0) {
        return Quaternion.fromXYZ((float)Math.toRadians(var0.x()), (float)Math.toRadians(var0.y()), (float)Math.toRadians(var0.z()));
    }

    public static Quaternion fromXYZ(Vector3fa var0) {
        return Quaternion.fromXYZ(var0.x(), var0.y(), var0.z());
    }

    public static Quaternion fromXYZ(float var0, float var1, float var2) {
        Quaternion var3 = ONE.copy();
        var3.mul(new Quaternion((float)Math.sin(var0 / 2.0f), 0.0f, 0.0f, (float)Math.cos(var0 / 2.0f)));
        var3.mul(new Quaternion(0.0f, (float)Math.sin(var1 / 2.0f), 0.0f, (float)Math.cos(var1 / 2.0f)));
        var3.mul(new Quaternion(0.0f, 0.0f, (float)Math.sin(var2 / 2.0f), (float)Math.cos(var2 / 2.0f)));
        return var3;
    }

    public Vector3fa toXYZ() {
        float var0 = this.r() * this.r();
        float var1 = this.i() * this.i();
        float var2 = this.j() * this.j();
        float var3 = this.k() * this.k();
        float var4 = var0 + var1 + var2 + var3;
        float var5 = 2.0f * this.r() * this.i() - 2.0f * this.j() * this.k();
        float var6 = (float)Math.asin(var5 / var4);
        if (Math.abs(var5) > 0.999f * var4) {
            return new Vector3fa(2.0f * (float)Math.atan2(this.i(), this.r()), var6, 0.0f);
        }
        return new Vector3fa((float)Math.atan2(2.0f * this.j() * this.k() + 2.0f * this.i() * this.r(), var0 - var1 - var2 + var3), var6, (float)Math.atan2(2.0f * this.i() * this.j() + 2.0f * this.r() * this.k(), var0 + var1 - var2 - var3));
    }

    public Vector3fa toXYZDegrees() {
        Vector3fa var0 = this.toXYZ();
        return new Vector3fa((float)Math.toDegrees(var0.x()), (float)Math.toDegrees(var0.y()), (float)Math.toDegrees(var0.z()));
    }

    public Vector3fa toYXZ() {
        float var0 = this.r() * this.r();
        float var1 = this.i() * this.i();
        float var2 = this.j() * this.j();
        float var3 = this.k() * this.k();
        float var4 = var0 + var1 + var2 + var3;
        float var5 = 2.0f * this.r() * this.i() - 2.0f * this.j() * this.k();
        float var6 = (float)Math.asin(var5 / var4);
        if (Math.abs(var5) > 0.999f * var4) {
            return new Vector3fa(var6, 2.0f * (float)Math.atan2(this.j(), this.r()), 0.0f);
        }
        return new Vector3fa(var6, (float)Math.atan2(2.0f * this.i() * this.k() + 2.0f * this.j() * this.r(), var0 - var1 - var2 + var3), (float)Math.atan2(2.0f * this.i() * this.j() + 2.0f * this.r() * this.k(), var0 - var1 + var2 - var3));
    }

    public Vector3fa toYXZDegrees() {
        Vector3fa var0 = this.toYXZ();
        return new Vector3fa((float)Math.toDegrees(var0.x()), (float)Math.toDegrees(var0.y()), (float)Math.toDegrees(var0.z()));
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        Quaternion var1 = (Quaternion)var0;
        if (Float.compare(var1.i, this.i) != 0) {
            return false;
        }
        if (Float.compare(var1.j, this.j) != 0) {
            return false;
        }
        if (Float.compare(var1.k, this.k) != 0) {
            return false;
        }
        return Float.compare(var1.r, this.r) == 0;
    }

    public int hashCode() {
        int var0 = Float.floatToIntBits(this.i);
        var0 = 31 * var0 + Float.floatToIntBits(this.j);
        var0 = 31 * var0 + Float.floatToIntBits(this.k);
        var0 = 31 * var0 + Float.floatToIntBits(this.r);
        return var0;
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder();
        var0.append("Quaternion[").append(this.r()).append(" + ");
        var0.append(this.i()).append("i + ");
        var0.append(this.j()).append("j + ");
        var0.append(this.k()).append("k]");
        return var0.toString();
    }

    public float i() {
        return this.i;
    }

    public float j() {
        return this.j;
    }

    public float k() {
        return this.k;
    }

    public float r() {
        return this.r;
    }

    public void mul(Quaternion var0) {
        float var1 = this.i();
        float var2 = this.j();
        float var3 = this.k();
        float var4 = this.r();
        float var5 = var0.i();
        float var6 = var0.j();
        float var7 = var0.k();
        float var8 = var0.r();
        this.i = var4 * var5 + var1 * var8 + var2 * var7 - var3 * var6;
        this.j = var4 * var6 - var1 * var7 + var2 * var8 + var3 * var5;
        this.k = var4 * var7 + var1 * var6 - var2 * var5 + var3 * var8;
        this.r = var4 * var8 - var1 * var5 - var2 * var6 - var3 * var7;
    }

    public void mul(float var0) {
        this.i *= var0;
        this.j *= var0;
        this.k *= var0;
        this.r *= var0;
    }

    public void conj() {
        this.i = -this.i;
        this.j = -this.j;
        this.k = -this.k;
    }

    public void set(float var0, float var1, float var2, float var3) {
        this.i = var0;
        this.j = var1;
        this.k = var2;
        this.r = var3;
    }

    private static float cos(float var0) {
        return (float)Math.cos(var0);
    }

    private static float sin(float var0) {
        return (float)Math.sin(var0);
    }

    public void normalize() {
        float var0 = this.i() * this.i() + this.j() * this.j() + this.k() * this.k() + this.r() * this.r();
        if (var0 > 1.0E-6f) {
            float var1 = MathHelper.fastInvSqrt(var0);
            this.i *= var1;
            this.j *= var1;
            this.k *= var1;
            this.r *= var1;
        } else {
            this.i = 0.0f;
            this.j = 0.0f;
            this.k = 0.0f;
            this.r = 0.0f;
        }
    }

    public void slerp(Quaternion var0, float var1) {
        throw new UnsupportedOperationException();
    }

    public Quaternion copy() {
        return new Quaternion(this);
    }
}

