/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionLimitCount
extends LootItemFunctionConditional {
    final IntRange limiter;

    LootItemFunctionLimitCount(LootItemCondition[] var0, IntRange var1) {
        super(var0);
        this.limiter = var1;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.LIMIT_COUNT;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.limiter.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        int var2 = this.limiter.clamp(var1, var0.getCount());
        var0.setCount(var2);
        return var0;
    }

    public static LootItemFunctionConditional.a<?> limitCount(IntRange var0) {
        return LootItemFunctionLimitCount.simpleBuilder(var1 -> new LootItemFunctionLimitCount((LootItemCondition[])var1, var0));
    }

    public static class a
    extends LootItemFunctionConditional.c<LootItemFunctionLimitCount> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionLimitCount var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.add("limit", var2.serialize((Object)var1.limiter));
        }

        @Override
        public LootItemFunctionLimitCount deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            IntRange var3 = ChatDeserializer.getAsObject(var0, "limit", var1, IntRange.class);
            return new LootItemFunctionLimitCount(var2, var3);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

