/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.LootEntryChildren;
import net.minecraft.world.level.storage.loot.entries.LootEntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootEntrySequence;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.apache.commons.lang3.ArrayUtils;

public abstract class LootEntryAbstract
implements LootEntryChildren {
    protected final LootItemCondition[] conditions;
    private final Predicate<LootTableInfo> compositeCondition;

    protected LootEntryAbstract(LootItemCondition[] var0) {
        this.conditions = var0;
        this.compositeCondition = LootItemConditions.andConditions(var0);
    }

    public void validate(LootCollector var0) {
        for (int var1 = 0; var1 < this.conditions.length; ++var1) {
            this.conditions[var1].validate(var0.forChild(".condition[" + var1 + "]"));
        }
    }

    protected final boolean canRun(LootTableInfo var0) {
        return this.compositeCondition.test(var0);
    }

    public abstract LootEntryType getType();

    public static abstract class Serializer<T extends LootEntryAbstract>
    implements LootSerializer<T> {
        @Override
        public final void serialize(JsonObject var0, T var1, JsonSerializationContext var2) {
            if (!ArrayUtils.isEmpty((Object[])((LootEntryAbstract)var1).conditions)) {
                var0.add("conditions", var2.serialize((Object)((LootEntryAbstract)var1).conditions));
            }
            this.serializeCustom(var0, var1, var2);
        }

        @Override
        public final T deserialize(JsonObject var0, JsonDeserializationContext var1) {
            LootItemCondition[] var2 = ChatDeserializer.getAsObject(var0, "conditions", new LootItemCondition[0], var1, LootItemCondition[].class);
            return this.deserializeCustom(var0, var1, var2);
        }

        public abstract void serializeCustom(JsonObject var1, T var2, JsonSerializationContext var3);

        public abstract T deserializeCustom(JsonObject var1, JsonDeserializationContext var2, LootItemCondition[] var3);

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }

        @Override
        public /* synthetic */ void serialize(JsonObject jsonObject, Object object, JsonSerializationContext jsonSerializationContext) {
            this.serialize(jsonObject, (T)((LootEntryAbstract)object), jsonSerializationContext);
        }
    }

    public static abstract class a<T extends a<T>>
    implements LootItemConditionUser<T> {
        private final List<LootItemCondition> conditions = Lists.newArrayList();

        protected abstract T getThis();

        @Override
        public T when(LootItemCondition.a var0) {
            this.conditions.add(var0.build());
            return this.getThis();
        }

        @Override
        public final T unwrap() {
            return this.getThis();
        }

        protected LootItemCondition[] getConditions() {
            return this.conditions.toArray(new LootItemCondition[0]);
        }

        public LootEntryAlternatives.a otherwise(a<?> var0) {
            return new LootEntryAlternatives.a(this, var0);
        }

        public LootEntryGroup.a append(a<?> var0) {
            return new LootEntryGroup.a(this, var0);
        }

        public LootEntrySequence.a then(a<?> var0) {
            return new LootEntrySequence.a(this, var0);
        }

        public abstract LootEntryAbstract build();

        @Override
        public /* synthetic */ LootItemConditionUser unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ LootItemConditionUser when(LootItemCondition.a a2) {
            return this.when(a2);
        }
    }
}

