/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootCollector {
    private final Multimap<String, String> problems;
    private final Supplier<String> context;
    private final LootContextParameterSet params;
    private final Function<MinecraftKey, LootItemCondition> conditionResolver;
    private final Set<MinecraftKey> visitedConditions;
    private final Function<MinecraftKey, LootTable> tableResolver;
    private final Set<MinecraftKey> visitedTables;
    private String contextCache;

    public LootCollector(LootContextParameterSet var0, Function<MinecraftKey, LootItemCondition> var1, Function<MinecraftKey, LootTable> var2) {
        this((Multimap<String, String>)HashMultimap.create(), () -> "", var0, var1, (Set<MinecraftKey>)ImmutableSet.of(), var2, (Set<MinecraftKey>)ImmutableSet.of());
    }

    public LootCollector(Multimap<String, String> var0, Supplier<String> var1, LootContextParameterSet var2, Function<MinecraftKey, LootItemCondition> var3, Set<MinecraftKey> var4, Function<MinecraftKey, LootTable> var5, Set<MinecraftKey> var6) {
        this.problems = var0;
        this.context = var1;
        this.params = var2;
        this.conditionResolver = var3;
        this.visitedConditions = var4;
        this.tableResolver = var5;
        this.visitedTables = var6;
    }

    private String getContext() {
        if (this.contextCache == null) {
            this.contextCache = this.context.get();
        }
        return this.contextCache;
    }

    public void reportProblem(String var0) {
        this.problems.put((Object)this.getContext(), (Object)var0);
    }

    public LootCollector forChild(String var0) {
        return new LootCollector(this.problems, () -> this.getContext() + var0, this.params, this.conditionResolver, this.visitedConditions, this.tableResolver, this.visitedTables);
    }

    public LootCollector enterTable(String var0, MinecraftKey var1) {
        ImmutableSet var2 = ImmutableSet.builder().addAll(this.visitedTables).add((Object)var1).build();
        return new LootCollector(this.problems, () -> this.getContext() + var0, this.params, this.conditionResolver, this.visitedConditions, this.tableResolver, (Set<MinecraftKey>)var2);
    }

    public LootCollector enterCondition(String var0, MinecraftKey var1) {
        ImmutableSet var2 = ImmutableSet.builder().addAll(this.visitedConditions).add((Object)var1).build();
        return new LootCollector(this.problems, () -> this.getContext() + var0, this.params, this.conditionResolver, (Set<MinecraftKey>)var2, this.tableResolver, this.visitedTables);
    }

    public boolean hasVisitedTable(MinecraftKey var0) {
        return this.visitedTables.contains(var0);
    }

    public boolean hasVisitedCondition(MinecraftKey var0) {
        return this.visitedConditions.contains(var0);
    }

    public Multimap<String, String> getProblems() {
        return ImmutableMultimap.copyOf(this.problems);
    }

    public void validateUser(LootItemUser var0) {
        this.params.validateUser(this, var0);
    }

    @Nullable
    public LootTable resolveLootTable(MinecraftKey var0) {
        return this.tableResolver.apply(var0);
    }

    @Nullable
    public LootItemCondition resolveCondition(MinecraftKey var0) {
        return this.conditionResolver.apply(var0);
    }

    public LootCollector setParams(LootContextParameterSet var0) {
        return new LootCollector(this.problems, this.context, var0, this.conditionResolver, this.visitedConditions, this.tableResolver, this.visitedTables);
    }
}

