/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;

public class WorldMapFrame {
    private final BlockPosition pos;
    private final int rotation;
    private final int entityId;

    public WorldMapFrame(BlockPosition var0, int var1, int var2) {
        this.pos = var0;
        this.rotation = var1;
        this.entityId = var2;
    }

    public static WorldMapFrame load(NBTTagCompound var0) {
        BlockPosition var1 = GameProfileSerializer.readBlockPos(var0.getCompound("Pos"));
        int var2 = var0.getInt("Rotation");
        int var3 = var0.getInt("EntityId");
        return new WorldMapFrame(var1, var2, var3);
    }

    public NBTTagCompound save() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.put("Pos", GameProfileSerializer.writeBlockPos(this.pos));
        var0.putInt("Rotation", this.rotation);
        var0.putInt("EntityId", this.entityId);
        return var0;
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getId() {
        return WorldMapFrame.frameId(this.pos);
    }

    public static String frameId(BlockPosition var0) {
        return "frame-" + var0.getX() + "," + var0.getY() + "," + var0.getZ();
    }
}

