/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.slf4j.Logger;

public abstract class PersistentBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean dirty;

    public abstract NBTTagCompound save(NBTTagCompound var1);

    public void setDirty() {
        this.setDirty(true);
    }

    public void setDirty(boolean var0) {
        this.dirty = var0;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save(File var0) {
        if (!this.isDirty()) {
            return;
        }
        NBTTagCompound var1 = new NBTTagCompound();
        var1.put("data", this.save(new NBTTagCompound()));
        var1.putInt("DataVersion", SharedConstants.getCurrentVersion().getWorldVersion());
        try {
            NBTCompressedStreamTools.writeCompressed(var1, var0);
        }
        catch (IOException var2) {
            LOGGER.error("Could not save data {}", (Object)this, (Object)var2);
        }
        this.setDirty(false);
    }
}

