/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;

public class PathfinderWater
extends PathfinderAbstract {
    private final boolean allowBreaching;
    private final Long2ObjectMap<PathType> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public PathfinderWater(boolean var0) {
        this.allowBreaching = var0;
    }

    @Override
    public void prepare(ChunkCache var0, EntityInsentient var1) {
        super.prepare(var0, var1);
        this.pathTypesByPosCache.clear();
    }

    @Override
    public void done() {
        super.done();
        this.pathTypesByPosCache.clear();
    }

    @Override
    @Nullable
    public PathPoint getStart() {
        return super.getNode(MathHelper.floor(this.mob.getBoundingBox().minX), MathHelper.floor(this.mob.getBoundingBox().minY + 0.5), MathHelper.floor(this.mob.getBoundingBox().minZ));
    }

    @Override
    @Nullable
    public PathDestination getGoal(double var0, double var2, double var4) {
        return this.getTargetFromNode(super.getNode(MathHelper.floor(var0), MathHelper.floor(var2), MathHelper.floor(var4)));
    }

    @Override
    public int getNeighbors(PathPoint[] var0, PathPoint var1) {
        int var2 = 0;
        EnumMap var3 = Maps.newEnumMap(EnumDirection.class);
        for (EnumDirection enumDirection : EnumDirection.values()) {
            PathPoint var8 = this.getNode(var1.x + enumDirection.getStepX(), var1.y + enumDirection.getStepY(), var1.z + enumDirection.getStepZ());
            var3.put(enumDirection, var8);
            if (!this.isNodeValid(var8)) continue;
            var0[var2++] = var8;
        }
        for (EnumDirection var5 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            EnumDirection var6 = var5.getClockWise();
            PathPoint pathPoint = this.getNode(var1.x + var5.getStepX() + var6.getStepX(), var1.y, var1.z + var5.getStepZ() + var6.getStepZ());
            if (!this.isDiagonalNodeValid(pathPoint, (PathPoint)var3.get(var5), (PathPoint)var3.get(var6))) continue;
            var0[var2++] = pathPoint;
        }
        return var2;
    }

    protected boolean isNodeValid(@Nullable PathPoint var0) {
        return var0 != null && !var0.closed;
    }

    protected boolean isDiagonalNodeValid(@Nullable PathPoint var0, @Nullable PathPoint var1, @Nullable PathPoint var2) {
        return this.isNodeValid(var0) && var1 != null && var1.costMalus >= 0.0f && var2 != null && var2.costMalus >= 0.0f;
    }

    @Override
    @Nullable
    protected PathPoint getNode(int var0, int var1, int var2) {
        float var5;
        PathPoint var3 = null;
        PathType var4 = this.getCachedBlockType(var0, var1, var2);
        if ((this.allowBreaching && var4 == PathType.BREACH || var4 == PathType.WATER) && (var5 = this.mob.getPathfindingMalus(var4)) >= 0.0f && (var3 = super.getNode(var0, var1, var2)) != null) {
            var3.type = var4;
            var3.costMalus = Math.max(var3.costMalus, var5);
            if (this.level.getFluidState(new BlockPosition(var0, var1, var2)).isEmpty()) {
                var3.costMalus += 8.0f;
            }
        }
        return var3;
    }

    protected PathType getCachedBlockType(int var0, int var1, int var2) {
        return (PathType)((Object)this.pathTypesByPosCache.computeIfAbsent(BlockPosition.asLong(var0, var1, var2), var3 -> this.getBlockPathType(this.level, var0, var1, var2)));
    }

    @Override
    public PathType getBlockPathType(IBlockAccess var0, int var1, int var2, int var3) {
        return this.getBlockPathType(var0, var1, var2, var3, this.mob, this.entityWidth, this.entityHeight, this.entityDepth, this.canOpenDoors(), this.canPassDoors());
    }

    @Override
    public PathType getBlockPathType(IBlockAccess var0, int var1, int var2, int var3, EntityInsentient var4, int var5, int var6, int var7, boolean var8, boolean var9) {
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        for (int var11 = var1; var11 < var1 + var5; ++var11) {
            for (int var12 = var2; var12 < var2 + var6; ++var12) {
                for (int var13 = var3; var13 < var3 + var7; ++var13) {
                    Fluid var14 = var0.getFluidState(var10.set(var11, var12, var13));
                    IBlockData var15 = var0.getBlockState(var10.set(var11, var12, var13));
                    if (var14.isEmpty() && var15.isPathfindable(var0, (BlockPosition)var10.below(), PathMode.WATER) && var15.isAir()) {
                        return PathType.BREACH;
                    }
                    if (var14.is(TagsFluid.WATER)) continue;
                    return PathType.BLOCKED;
                }
            }
        }
        IBlockData var11 = var0.getBlockState(var10);
        if (var11.isPathfindable(var0, var10, PathMode.WATER)) {
            return PathType.WATER;
        }
        return PathType.BLOCKED;
    }
}

