/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;

public abstract class PathfinderAbstract {
    protected ChunkCache level;
    protected EntityInsentient mob;
    protected final Int2ObjectMap<PathPoint> nodes = new Int2ObjectOpenHashMap();
    protected int entityWidth;
    protected int entityHeight;
    protected int entityDepth;
    protected boolean canPassDoors;
    protected boolean canOpenDoors;
    protected boolean canFloat;

    public void prepare(ChunkCache var0, EntityInsentient var1) {
        this.level = var0;
        this.mob = var1;
        this.nodes.clear();
        this.entityWidth = MathHelper.floor(var1.getBbWidth() + 1.0f);
        this.entityHeight = MathHelper.floor(var1.getBbHeight() + 1.0f);
        this.entityDepth = MathHelper.floor(var1.getBbWidth() + 1.0f);
    }

    public void done() {
        this.level = null;
        this.mob = null;
    }

    @Nullable
    protected PathPoint getNode(BlockPosition var0) {
        return this.getNode(var0.getX(), var0.getY(), var0.getZ());
    }

    @Nullable
    protected PathPoint getNode(int var0, int var1, int var2) {
        return (PathPoint)this.nodes.computeIfAbsent(PathPoint.createHash(var0, var1, var2), var3 -> new PathPoint(var0, var1, var2));
    }

    @Nullable
    public abstract PathPoint getStart();

    @Nullable
    public abstract PathDestination getGoal(double var1, double var3, double var5);

    @Nullable
    protected PathDestination getTargetFromNode(@Nullable PathPoint var0) {
        if (var0 != null) {
            return new PathDestination(var0);
        }
        return null;
    }

    public abstract int getNeighbors(PathPoint[] var1, PathPoint var2);

    public abstract PathType getBlockPathType(IBlockAccess var1, int var2, int var3, int var4, EntityInsentient var5, int var6, int var7, int var8, boolean var9, boolean var10);

    public abstract PathType getBlockPathType(IBlockAccess var1, int var2, int var3, int var4);

    public void setCanPassDoors(boolean var0) {
        this.canPassDoors = var0;
    }

    public void setCanOpenDoors(boolean var0) {
        this.canOpenDoors = var0;
    }

    public void setCanFloat(boolean var0) {
        this.canFloat = var0;
    }

    public boolean canPassDoors() {
        return this.canPassDoors;
    }

    public boolean canOpenDoors() {
        return this.canOpenDoors;
    }

    public boolean canFloat() {
        return this.canFloat;
    }
}

