/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Fluid
extends IBlockDataHolder<FluidType, Fluid> {
    public static final Codec<Fluid> CODEC = Fluid.codec(IRegistry.FLUID.byNameCodec(), FluidType::defaultFluidState).stable();
    public static final int AMOUNT_MAX = 9;
    public static final int AMOUNT_FULL = 8;

    public Fluid(FluidType var0, ImmutableMap<IBlockState<?>, Comparable<?>> var1, MapCodec<Fluid> var2) {
        super(var0, var1, var2);
    }

    public FluidType getType() {
        return (FluidType)this.owner;
    }

    public boolean isSource() {
        return this.getType().isSource(this);
    }

    public boolean isSourceOfType(FluidType var0) {
        return this.owner == var0 && ((FluidType)this.owner).isSource(this);
    }

    public boolean isEmpty() {
        return this.getType().isEmpty();
    }

    public float getHeight(IBlockAccess var0, BlockPosition var1) {
        return this.getType().getHeight(this, var0, var1);
    }

    public float getOwnHeight() {
        return this.getType().getOwnHeight(this);
    }

    public int getAmount() {
        return this.getType().getAmount(this);
    }

    public boolean shouldRenderBackwardUpFace(IBlockAccess var0, BlockPosition var1) {
        for (int var2 = -1; var2 <= 1; ++var2) {
            for (int var3 = -1; var3 <= 1; ++var3) {
                BlockPosition var4 = var1.offset(var2, 0, var3);
                Fluid var5 = var0.getFluidState(var4);
                if (var5.getType().isSame(this.getType()) || var0.getBlockState(var4).isSolidRender(var0, var4)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick(World var0, BlockPosition var1) {
        this.getType().tick(var0, var1, this);
    }

    public void animateTick(World var0, BlockPosition var1, RandomSource var2) {
        this.getType().animateTick(var0, var1, this, var2);
    }

    public boolean isRandomlyTicking() {
        return this.getType().isRandomlyTicking();
    }

    public void randomTick(World var0, BlockPosition var1, RandomSource var2) {
        this.getType().randomTick(var0, var1, this, var2);
    }

    public Vec3D getFlow(IBlockAccess var0, BlockPosition var1) {
        return this.getType().getFlow(var0, var1, this);
    }

    public IBlockData createLegacyBlock() {
        return this.getType().createLegacyBlock(this);
    }

    @Nullable
    public ParticleParam getDripParticle() {
        return this.getType().getDripParticle();
    }

    public boolean is(TagKey<FluidType> var0) {
        return this.getType().builtInRegistryHolder().is(var0);
    }

    public boolean is(HolderSet<FluidType> var0) {
        return var0.contains(this.getType().builtInRegistryHolder());
    }

    public boolean is(FluidType var0) {
        return this.getType() == var0;
    }

    public float getExplosionResistance() {
        return this.getType().getExplosionResistance();
    }

    public boolean canBeReplacedWith(IBlockAccess var0, BlockPosition var1, FluidType var2, EnumDirection var3) {
        return this.getType().canBeReplacedWith(this, var0, var1, var2, var3);
    }

    public VoxelShape getShape(IBlockAccess var0, BlockPosition var1) {
        return this.getType().getShape(this, var0, var1);
    }

    public Holder<FluidType> holder() {
        return ((FluidType)this.owner).builtInRegistryHolder();
    }

    public Stream<TagKey<FluidType>> getTags() {
        return ((FluidType)this.owner).builtInRegistryHolder().tags();
    }
}

