/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.LightEngineGraphSection;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayer;
import net.minecraft.world.level.lighting.LightEngineStorageArray;

public abstract class LightEngineStorage<M extends LightEngineStorageArray<M>>
extends LightEngineGraphSection {
    protected static final int LIGHT_AND_DATA = 0;
    protected static final int LIGHT_ONLY = 1;
    protected static final int EMPTY = 2;
    protected static final NibbleArray EMPTY_DATA = new NibbleArray();
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    private final EnumSkyBlock layer;
    private final ILightAccess chunkSource;
    protected final LongSet dataSectionSet = new LongOpenHashSet();
    protected final LongSet toMarkNoData = new LongOpenHashSet();
    protected final LongSet toMarkData = new LongOpenHashSet();
    protected volatile M visibleSectionData;
    protected final M updatingSectionData;
    protected final LongSet changedSections = new LongOpenHashSet();
    protected final LongSet sectionsAffectedByLightUpdates = new LongOpenHashSet();
    protected final Long2ObjectMap<NibbleArray> queuedSections = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final LongSet untrustedSections = new LongOpenHashSet();
    private final LongSet columnsToRetainQueuedDataFor = new LongOpenHashSet();
    private final LongSet toRemove = new LongOpenHashSet();
    protected volatile boolean hasToRemove;

    protected LightEngineStorage(EnumSkyBlock var0, ILightAccess var1, M var2) {
        super(3, 16, 256);
        this.layer = var0;
        this.chunkSource = var1;
        this.updatingSectionData = var2;
        this.visibleSectionData = ((LightEngineStorageArray)var2).copy();
        ((LightEngineStorageArray)this.visibleSectionData).disableCache();
    }

    protected boolean storingLightForSection(long var0) {
        return this.getDataLayer(var0, true) != null;
    }

    @Nullable
    protected NibbleArray getDataLayer(long var0, boolean var2) {
        return this.getDataLayer(var2 ? this.updatingSectionData : this.visibleSectionData, var0);
    }

    @Nullable
    protected NibbleArray getDataLayer(M var0, long var1) {
        return ((LightEngineStorageArray)var0).getLayer(var1);
    }

    @Nullable
    public NibbleArray getDataLayerData(long var0) {
        NibbleArray var2 = (NibbleArray)this.queuedSections.get(var0);
        if (var2 != null) {
            return var2;
        }
        return this.getDataLayer(var0, false);
    }

    protected abstract int getLightValue(long var1);

    protected int getStoredLevel(long var0) {
        long var2 = SectionPosition.blockToSection(var0);
        NibbleArray var4 = this.getDataLayer(var2, true);
        return var4.get(SectionPosition.sectionRelative(BlockPosition.getX(var0)), SectionPosition.sectionRelative(BlockPosition.getY(var0)), SectionPosition.sectionRelative(BlockPosition.getZ(var0)));
    }

    protected void setStoredLevel(long var0, int var2) {
        long var3 = SectionPosition.blockToSection(var0);
        if (this.changedSections.add(var3)) {
            ((LightEngineStorageArray)this.updatingSectionData).copyDataLayer(var3);
        }
        NibbleArray var5 = this.getDataLayer(var3, true);
        var5.set(SectionPosition.sectionRelative(BlockPosition.getX(var0)), SectionPosition.sectionRelative(BlockPosition.getY(var0)), SectionPosition.sectionRelative(BlockPosition.getZ(var0)), var2);
        SectionPosition.aroundAndAtBlockPos(var0, arg_0 -> ((LongSet)this.sectionsAffectedByLightUpdates).add(arg_0));
    }

    @Override
    protected int getLevel(long var0) {
        if (var0 == Long.MAX_VALUE) {
            return 2;
        }
        if (this.dataSectionSet.contains(var0)) {
            return 0;
        }
        if (!this.toRemove.contains(var0) && ((LightEngineStorageArray)this.updatingSectionData).hasLayer(var0)) {
            return 1;
        }
        return 2;
    }

    @Override
    protected int getLevelFromSource(long var0) {
        if (this.toMarkNoData.contains(var0)) {
            return 2;
        }
        if (this.dataSectionSet.contains(var0) || this.toMarkData.contains(var0)) {
            return 0;
        }
        return 2;
    }

    @Override
    protected void setLevel(long var0, int var2) {
        int var3 = this.getLevel(var0);
        if (var3 != 0 && var2 == 0) {
            this.dataSectionSet.add(var0);
            this.toMarkData.remove(var0);
        }
        if (var3 == 0 && var2 != 0) {
            this.dataSectionSet.remove(var0);
            this.toMarkNoData.remove(var0);
        }
        if (var3 >= 2 && var2 != 2) {
            if (this.toRemove.contains(var0)) {
                this.toRemove.remove(var0);
            } else {
                ((LightEngineStorageArray)this.updatingSectionData).setLayer(var0, this.createDataLayer(var0));
                this.changedSections.add(var0);
                this.onNodeAdded(var0);
                int var4 = SectionPosition.x(var0);
                int var5 = SectionPosition.y(var0);
                int var6 = SectionPosition.z(var0);
                for (int var7 = -1; var7 <= 1; ++var7) {
                    for (int var8 = -1; var8 <= 1; ++var8) {
                        for (int var9 = -1; var9 <= 1; ++var9) {
                            this.sectionsAffectedByLightUpdates.add(SectionPosition.asLong(var4 + var8, var5 + var9, var6 + var7));
                        }
                    }
                }
            }
        }
        if (var3 != 2 && var2 >= 2) {
            this.toRemove.add(var0);
        }
        this.hasToRemove = !this.toRemove.isEmpty();
    }

    protected NibbleArray createDataLayer(long var0) {
        NibbleArray var2 = (NibbleArray)this.queuedSections.get(var0);
        if (var2 != null) {
            return var2;
        }
        return new NibbleArray();
    }

    protected void clearQueuedSectionBlocks(LightEngineLayer<?, ?> var0, long var1) {
        if (var0.getQueueSize() == 0) {
            return;
        }
        if (var0.getQueueSize() < 8192) {
            var0.removeIf(var2 -> SectionPosition.blockToSection(var2) == var1);
            return;
        }
        int var3 = SectionPosition.sectionToBlockCoord(SectionPosition.x(var1));
        int var4 = SectionPosition.sectionToBlockCoord(SectionPosition.y(var1));
        int var5 = SectionPosition.sectionToBlockCoord(SectionPosition.z(var1));
        for (int var6 = 0; var6 < 16; ++var6) {
            for (int var7 = 0; var7 < 16; ++var7) {
                for (int var8 = 0; var8 < 16; ++var8) {
                    long var9 = BlockPosition.asLong(var3 + var6, var4 + var7, var5 + var8);
                    var0.removeFromQueue(var9);
                }
            }
        }
    }

    protected boolean hasInconsistencies() {
        return this.hasToRemove;
    }

    protected void markNewInconsistencies(LightEngineLayer<M, ?> var0, boolean var1, boolean var2) {
        long var5;
        NibbleArray var7;
        long var4;
        if (!this.hasInconsistencies() && this.queuedSections.isEmpty()) {
            return;
        }
        LongIterator longIterator = this.toRemove.iterator();
        while (longIterator.hasNext()) {
            var4 = (Long)longIterator.next();
            this.clearQueuedSectionBlocks(var0, var4);
            NibbleArray var6 = (NibbleArray)this.queuedSections.remove(var4);
            var7 = ((LightEngineStorageArray)this.updatingSectionData).removeLayer(var4);
            if (!this.columnsToRetainQueuedDataFor.contains(SectionPosition.getZeroNode(var4))) continue;
            if (var6 != null) {
                this.queuedSections.put(var4, (Object)var6);
                continue;
            }
            if (var7 == null) continue;
            this.queuedSections.put(var4, (Object)var7);
        }
        ((LightEngineStorageArray)this.updatingSectionData).clearCache();
        longIterator = this.toRemove.iterator();
        while (longIterator.hasNext()) {
            var4 = (Long)longIterator.next();
            this.onNodeRemoved(var4);
        }
        this.toRemove.clear();
        this.hasToRemove = false;
        for (Long2ObjectMap.Entry var42 : this.queuedSections.long2ObjectEntrySet()) {
            var5 = var42.getLongKey();
            if (!this.storingLightForSection(var5)) continue;
            var7 = (NibbleArray)var42.getValue();
            if (((LightEngineStorageArray)this.updatingSectionData).getLayer(var5) == var7) continue;
            this.clearQueuedSectionBlocks(var0, var5);
            ((LightEngineStorageArray)this.updatingSectionData).setLayer(var5, var7);
            this.changedSections.add(var5);
        }
        ((LightEngineStorageArray)this.updatingSectionData).clearCache();
        if (!var2) {
            longIterator = this.queuedSections.keySet().iterator();
            while (longIterator.hasNext()) {
                long var43 = (Long)longIterator.next();
                this.checkEdgesForSection(var0, var43);
            }
        } else {
            longIterator = this.untrustedSections.iterator();
            while (longIterator.hasNext()) {
                long var44 = (Long)longIterator.next();
                this.checkEdgesForSection(var0, var44);
            }
        }
        this.untrustedSections.clear();
        ObjectIterator var3 = this.queuedSections.long2ObjectEntrySet().iterator();
        while (var3.hasNext()) {
            Long2ObjectMap.Entry var45 = (Long2ObjectMap.Entry)var3.next();
            var5 = var45.getLongKey();
            if (!this.storingLightForSection(var5)) continue;
            var3.remove();
        }
    }

    private void checkEdgesForSection(LightEngineLayer<M, ?> var0, long var1) {
        if (!this.storingLightForSection(var1)) {
            return;
        }
        int var3 = SectionPosition.sectionToBlockCoord(SectionPosition.x(var1));
        int var4 = SectionPosition.sectionToBlockCoord(SectionPosition.y(var1));
        int var5 = SectionPosition.sectionToBlockCoord(SectionPosition.z(var1));
        for (EnumDirection var9 : DIRECTIONS) {
            long var10 = SectionPosition.offset(var1, var9);
            if (this.queuedSections.containsKey(var10) || !this.storingLightForSection(var10)) continue;
            for (int var12 = 0; var12 < 16; ++var12) {
                for (int var13 = 0; var13 < 16; ++var13) {
                    long var14;
                    long var16 = switch (var9) {
                        case EnumDirection.DOWN -> {
                            var14 = BlockPosition.asLong(var3 + var13, var4, var5 + var12);
                            yield BlockPosition.asLong(var3 + var13, var4 - 1, var5 + var12);
                        }
                        case EnumDirection.UP -> {
                            var14 = BlockPosition.asLong(var3 + var13, var4 + 16 - 1, var5 + var12);
                            yield BlockPosition.asLong(var3 + var13, var4 + 16, var5 + var12);
                        }
                        case EnumDirection.NORTH -> {
                            var14 = BlockPosition.asLong(var3 + var12, var4 + var13, var5);
                            yield BlockPosition.asLong(var3 + var12, var4 + var13, var5 - 1);
                        }
                        case EnumDirection.SOUTH -> {
                            var14 = BlockPosition.asLong(var3 + var12, var4 + var13, var5 + 16 - 1);
                            yield BlockPosition.asLong(var3 + var12, var4 + var13, var5 + 16);
                        }
                        case EnumDirection.WEST -> {
                            var14 = BlockPosition.asLong(var3, var4 + var12, var5 + var13);
                            yield BlockPosition.asLong(var3 - 1, var4 + var12, var5 + var13);
                        }
                        default -> {
                            var14 = BlockPosition.asLong(var3 + 16 - 1, var4 + var12, var5 + var13);
                            yield BlockPosition.asLong(var3 + 16, var4 + var12, var5 + var13);
                        }
                    };
                    var0.checkEdge(var14, var16, var0.computeLevelFromNeighbor(var14, var16, var0.getLevel(var14)), false);
                    var0.checkEdge(var16, var14, var0.computeLevelFromNeighbor(var16, var14, var0.getLevel(var16)), false);
                }
            }
        }
    }

    protected void onNodeAdded(long var0) {
    }

    protected void onNodeRemoved(long var0) {
    }

    protected void enableLightSources(long var0, boolean var2) {
    }

    public void retainData(long var0, boolean var2) {
        if (var2) {
            this.columnsToRetainQueuedDataFor.add(var0);
        } else {
            this.columnsToRetainQueuedDataFor.remove(var0);
        }
    }

    protected void queueSectionData(long var0, @Nullable NibbleArray var2, boolean var3) {
        if (var2 != null) {
            this.queuedSections.put(var0, (Object)var2);
            if (!var3) {
                this.untrustedSections.add(var0);
            }
        } else {
            this.queuedSections.remove(var0);
        }
    }

    protected void updateSectionStatus(long var0, boolean var2) {
        boolean var3 = this.dataSectionSet.contains(var0);
        if (!var3 && !var2) {
            this.toMarkData.add(var0);
            this.checkEdge(Long.MAX_VALUE, var0, 0, true);
        }
        if (var3 && var2) {
            this.toMarkNoData.add(var0);
            this.checkEdge(Long.MAX_VALUE, var0, 2, false);
        }
    }

    protected void runAllUpdates() {
        if (this.hasWork()) {
            this.runUpdates(Integer.MAX_VALUE);
        }
    }

    protected void swapSectionMap() {
        Object var0;
        if (!this.changedSections.isEmpty()) {
            var0 = ((LightEngineStorageArray)this.updatingSectionData).copy();
            ((LightEngineStorageArray)var0).disableCache();
            this.visibleSectionData = var0;
            this.changedSections.clear();
        }
        if (!this.sectionsAffectedByLightUpdates.isEmpty()) {
            var0 = this.sectionsAffectedByLightUpdates.iterator();
            while (var0.hasNext()) {
                long var1 = var0.nextLong();
                this.chunkSource.onLightUpdate(this.layer, SectionPosition.of(var1));
            }
            this.sectionsAffectedByLightUpdates.clear();
        }
    }
}

