/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenScatteredPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;

public class SwampHutPiece
extends WorldGenScatteredPiece {
    private boolean spawnedWitch;
    private boolean spawnedCat;

    public SwampHutPiece(RandomSource var0, int var1, int var2) {
        super(WorldGenFeatureStructurePieceType.SWAMPLAND_HUT, var1, 64, var2, 7, 7, 9, SwampHutPiece.getRandomHorizontalDirection(var0));
    }

    public SwampHutPiece(NBTTagCompound var0) {
        super(WorldGenFeatureStructurePieceType.SWAMPLAND_HUT, var0);
        this.spawnedWitch = var0.getBoolean("Witch");
        this.spawnedCat = var0.getBoolean("Cat");
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
        super.addAdditionalSaveData(var0, var1);
        var1.putBoolean("Witch", this.spawnedWitch);
        var1.putBoolean("Cat", this.spawnedCat);
    }

    @Override
    public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
        BlockPosition.MutableBlockPosition var11;
        if (!this.updateAverageGroundHeight(var0, var4, 0)) {
            return;
        }
        this.generateBox(var0, var4, 1, 1, 1, 5, 1, 7, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
        this.generateBox(var0, var4, 1, 4, 2, 5, 4, 7, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
        this.generateBox(var0, var4, 2, 1, 0, 4, 1, 0, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
        this.generateBox(var0, var4, 2, 2, 2, 3, 3, 2, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
        this.generateBox(var0, var4, 1, 2, 3, 1, 3, 6, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
        this.generateBox(var0, var4, 5, 2, 3, 5, 3, 6, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
        this.generateBox(var0, var4, 2, 2, 7, 4, 3, 7, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
        this.generateBox(var0, var4, 1, 0, 2, 1, 3, 2, Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState(), false);
        this.generateBox(var0, var4, 5, 0, 2, 5, 3, 2, Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState(), false);
        this.generateBox(var0, var4, 1, 0, 7, 1, 3, 7, Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState(), false);
        this.generateBox(var0, var4, 5, 0, 7, 5, 3, 7, Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState(), false);
        this.placeBlock(var0, Blocks.OAK_FENCE.defaultBlockState(), 2, 3, 2, var4);
        this.placeBlock(var0, Blocks.OAK_FENCE.defaultBlockState(), 3, 3, 7, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 1, 3, 4, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 5, 3, 4, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 5, 3, 5, var4);
        this.placeBlock(var0, Blocks.POTTED_RED_MUSHROOM.defaultBlockState(), 1, 3, 5, var4);
        this.placeBlock(var0, Blocks.CRAFTING_TABLE.defaultBlockState(), 3, 2, 6, var4);
        this.placeBlock(var0, Blocks.CAULDRON.defaultBlockState(), 4, 2, 6, var4);
        this.placeBlock(var0, Blocks.OAK_FENCE.defaultBlockState(), 1, 2, 1, var4);
        this.placeBlock(var0, Blocks.OAK_FENCE.defaultBlockState(), 5, 2, 1, var4);
        IBlockData var7 = (IBlockData)Blocks.SPRUCE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.NORTH);
        IBlockData var8 = (IBlockData)Blocks.SPRUCE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.EAST);
        IBlockData var9 = (IBlockData)Blocks.SPRUCE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.WEST);
        IBlockData var10 = (IBlockData)Blocks.SPRUCE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.SOUTH);
        this.generateBox(var0, var4, 0, 4, 1, 6, 4, 1, var7, var7, false);
        this.generateBox(var0, var4, 0, 4, 2, 0, 4, 7, var8, var8, false);
        this.generateBox(var0, var4, 6, 4, 2, 6, 4, 7, var9, var9, false);
        this.generateBox(var0, var4, 0, 4, 8, 6, 4, 8, var10, var10, false);
        this.placeBlock(var0, (IBlockData)var7.setValue(BlockStairs.SHAPE, BlockPropertyStairsShape.OUTER_RIGHT), 0, 4, 1, var4);
        this.placeBlock(var0, (IBlockData)var7.setValue(BlockStairs.SHAPE, BlockPropertyStairsShape.OUTER_LEFT), 6, 4, 1, var4);
        this.placeBlock(var0, (IBlockData)var10.setValue(BlockStairs.SHAPE, BlockPropertyStairsShape.OUTER_LEFT), 0, 4, 8, var4);
        this.placeBlock(var0, (IBlockData)var10.setValue(BlockStairs.SHAPE, BlockPropertyStairsShape.OUTER_RIGHT), 6, 4, 8, var4);
        for (int var112 = 2; var112 <= 7; var112 += 5) {
            for (int var12 = 1; var12 <= 5; var12 += 4) {
                this.fillColumnDown(var0, Blocks.OAK_LOG.defaultBlockState(), var12, -1, var112, var4);
            }
        }
        if (!this.spawnedWitch && var4.isInside(var11 = this.getWorldPos(2, 2, 5))) {
            this.spawnedWitch = true;
            EntityWitch var12 = EntityTypes.WITCH.create(var0.getLevel());
            var12.setPersistenceRequired();
            var12.moveTo((double)var11.getX() + 0.5, var11.getY(), (double)var11.getZ() + 0.5, 0.0f, 0.0f);
            var12.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var11), EnumMobSpawn.STRUCTURE, null, null);
            var0.addFreshEntityWithPassengers(var12);
        }
        this.spawnCat(var0, var4);
    }

    private void spawnCat(WorldAccess var0, StructureBoundingBox var1) {
        BlockPosition.MutableBlockPosition var2;
        if (!this.spawnedCat && var1.isInside(var2 = this.getWorldPos(2, 2, 5))) {
            this.spawnedCat = true;
            EntityCat var3 = EntityTypes.CAT.create(var0.getLevel());
            var3.setPersistenceRequired();
            var3.moveTo((double)var2.getX() + 0.5, var2.getY(), (double)var2.getZ() + 0.5, 0.0f, 0.0f);
            var3.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var2), EnumMobSpawn.STRUCTURE, null, null);
            var0.addFreshEntityWithPassengers(var3);
        }
    }
}

