/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class NoiseThresholdProvider
extends NoiseBasedStateProvider {
    public static final Codec<NoiseThresholdProvider> CODEC = RecordCodecBuilder.create(var02 -> NoiseThresholdProvider.noiseCodec(var02).and(var02.group((App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("threshold").forGetter(var0 -> Float.valueOf(var0.threshold)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("high_chance").forGetter(var0 -> Float.valueOf(var0.highChance)), (App)IBlockData.CODEC.fieldOf("default_state").forGetter(var0 -> var0.defaultState), (App)Codec.list(IBlockData.CODEC).fieldOf("low_states").forGetter(var0 -> var0.lowStates), (App)Codec.list(IBlockData.CODEC).fieldOf("high_states").forGetter(var0 -> var0.highStates))).apply((Applicative)var02, NoiseThresholdProvider::new));
    private final float threshold;
    private final float highChance;
    private final IBlockData defaultState;
    private final List<IBlockData> lowStates;
    private final List<IBlockData> highStates;

    public NoiseThresholdProvider(long var0, NoiseGeneratorNormal.a var2, float var3, float var4, float var5, IBlockData var6, List<IBlockData> var7, List<IBlockData> var8) {
        super(var0, var2, var3);
        this.threshold = var4;
        this.highChance = var5;
        this.defaultState = var6;
        this.lowStates = var7;
        this.highStates = var8;
    }

    @Override
    protected WorldGenFeatureStateProviders<?> type() {
        return WorldGenFeatureStateProviders.NOISE_THRESHOLD_PROVIDER;
    }

    @Override
    public IBlockData getState(RandomSource var0, BlockPosition var1) {
        double var2 = this.getNoiseValue(var1, this.scale);
        if (var2 < (double)this.threshold) {
            return SystemUtils.getRandom(this.lowStates, var0);
        }
        if (var0.nextFloat() < this.highChance) {
            return SystemUtils.getRandom(this.highStates, var0);
        }
        return this.defaultState;
    }
}

