/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEndSpikeConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;

public class WorldGenEnder
extends WorldGenerator<WorldGenFeatureEndSpikeConfiguration> {
    public static final int NUMBER_OF_SPIKES = 10;
    private static final int SPIKE_DISTANCE = 42;
    private static final LoadingCache<Long, List<Spike>> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new b());

    public WorldGenEnder(Codec<WorldGenFeatureEndSpikeConfiguration> var0) {
        super(var0);
    }

    public static List<Spike> getSpikesForLevel(GeneratorAccessSeed var0) {
        RandomSource var1 = RandomSource.create(var0.getSeed());
        long var2 = var1.nextLong() & 0xFFFFL;
        return (List)SPIKE_CACHE.getUnchecked((Object)var2);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEndSpikeConfiguration> var0) {
        WorldGenFeatureEndSpikeConfiguration var1 = var0.config();
        GeneratorAccessSeed var2 = var0.level();
        RandomSource var3 = var0.random();
        BlockPosition var4 = var0.origin();
        List<Spike> var5 = var1.getSpikes();
        if (var5.isEmpty()) {
            var5 = WorldGenEnder.getSpikesForLevel(var2);
        }
        for (Spike var7 : var5) {
            if (!var7.isCenterWithinChunk(var4)) continue;
            this.placeSpike(var2, var3, var1, var7);
        }
        return true;
    }

    private void placeSpike(WorldAccess var0, RandomSource var1, WorldGenFeatureEndSpikeConfiguration var2, Spike var3) {
        int var4 = var3.getRadius();
        for (BlockPosition var6 : BlockPosition.betweenClosed(new BlockPosition(var3.getCenterX() - var4, var0.getMinBuildHeight(), var3.getCenterZ() - var4), new BlockPosition(var3.getCenterX() + var4, var3.getHeight() + 10, var3.getCenterZ() + var4))) {
            if (var6.distToLowCornerSqr(var3.getCenterX(), var6.getY(), var3.getCenterZ()) <= (double)(var4 * var4 + 1) && var6.getY() < var3.getHeight()) {
                this.setBlock(var0, var6, Blocks.OBSIDIAN.defaultBlockState());
                continue;
            }
            if (var6.getY() <= 65) continue;
            this.setBlock(var0, var6, Blocks.AIR.defaultBlockState());
        }
        if (var3.isGuarded()) {
            int var5 = -2;
            int var6 = 2;
            int var7 = 3;
            BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
            for (int var9 = -2; var9 <= 2; ++var9) {
                for (int var10 = -2; var10 <= 2; ++var10) {
                    for (int var11 = 0; var11 <= 3; ++var11) {
                        boolean var14;
                        boolean var12 = MathHelper.abs(var9) == 2;
                        boolean var13 = MathHelper.abs(var10) == 2;
                        boolean bl = var14 = var11 == 3;
                        if (!var12 && !var13 && !var14) continue;
                        boolean var15 = var9 == -2 || var9 == 2 || var14;
                        boolean var16 = var10 == -2 || var10 == 2 || var14;
                        IBlockData var17 = (IBlockData)((IBlockData)((IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, var15 && var10 != -2)).setValue(BlockIronBars.SOUTH, var15 && var10 != 2)).setValue(BlockIronBars.WEST, var16 && var9 != -2)).setValue(BlockIronBars.EAST, var16 && var9 != 2);
                        this.setBlock(var0, var8.set(var3.getCenterX() + var9, var3.getHeight() + var11, var3.getCenterZ() + var10), var17);
                    }
                }
            }
        }
        EntityEnderCrystal var5 = EntityTypes.END_CRYSTAL.create(var0.getLevel());
        var5.setBeamTarget(var2.getCrystalBeamTarget());
        var5.setInvulnerable(var2.isCrystalInvulnerable());
        var5.moveTo((double)var3.getCenterX() + 0.5, var3.getHeight() + 1, (double)var3.getCenterZ() + 0.5, var1.nextFloat() * 360.0f, 0.0f);
        var0.addFreshEntity(var5);
        this.setBlock(var0, new BlockPosition(var3.getCenterX(), var3.getHeight(), var3.getCenterZ()), Blocks.BEDROCK.defaultBlockState());
    }

    public static class Spike {
        public static final Codec<Spike> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("centerX").orElse((Object)0).forGetter(var0 -> var0.centerX), (App)Codec.INT.fieldOf("centerZ").orElse((Object)0).forGetter(var0 -> var0.centerZ), (App)Codec.INT.fieldOf("radius").orElse((Object)0).forGetter(var0 -> var0.radius), (App)Codec.INT.fieldOf("height").orElse((Object)0).forGetter(var0 -> var0.height), (App)Codec.BOOL.fieldOf("guarded").orElse((Object)false).forGetter(var0 -> var0.guarded)).apply((Applicative)var02, Spike::new));
        private final int centerX;
        private final int centerZ;
        private final int radius;
        private final int height;
        private final boolean guarded;
        private final AxisAlignedBB topBoundingBox;

        public Spike(int var0, int var1, int var2, int var3, boolean var4) {
            this.centerX = var0;
            this.centerZ = var1;
            this.radius = var2;
            this.height = var3;
            this.guarded = var4;
            this.topBoundingBox = new AxisAlignedBB(var0 - var2, DimensionManager.MIN_Y, var1 - var2, var0 + var2, DimensionManager.MAX_Y, var1 + var2);
        }

        public boolean isCenterWithinChunk(BlockPosition var0) {
            return SectionPosition.blockToSectionCoord(var0.getX()) == SectionPosition.blockToSectionCoord(this.centerX) && SectionPosition.blockToSectionCoord(var0.getZ()) == SectionPosition.blockToSectionCoord(this.centerZ);
        }

        public int getCenterX() {
            return this.centerX;
        }

        public int getCenterZ() {
            return this.centerZ;
        }

        public int getRadius() {
            return this.radius;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isGuarded() {
            return this.guarded;
        }

        public AxisAlignedBB getTopBoundingBox() {
            return this.topBoundingBox;
        }
    }

    static class b
    extends CacheLoader<Long, List<Spike>> {
        b() {
        }

        public List<Spike> load(Long var0) {
            IntArrayList var1 = SystemUtils.toShuffledList(IntStream.range(0, 10), RandomSource.create(var0));
            ArrayList var2 = Lists.newArrayList();
            for (int var3 = 0; var3 < 10; ++var3) {
                int var4 = MathHelper.floor(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)var3)));
                int var5 = MathHelper.floor(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)var3)));
                int var6 = var1.get(var3);
                int var7 = 2 + var6 / 3;
                int var8 = 76 + var6 * 3;
                boolean var9 = var6 == 1 || var6 == 2;
                var2.add(new Spike(var4, var5, var7, var8, var9));
            }
            return var2;
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((Long)object);
        }
    }
}

