/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.SculkPatchConfiguration;

public class SculkPatchFeature
extends WorldGenerator<SculkPatchConfiguration> {
    public SculkPatchFeature(Codec<SculkPatchConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<SculkPatchConfiguration> var0) {
        int var9;
        int var8;
        BlockPosition var2;
        GeneratorAccessSeed var1 = var0.level();
        if (!this.canSpreadFrom(var1, var2 = var0.origin())) {
            return false;
        }
        SculkPatchConfiguration var3 = var0.config();
        RandomSource var4 = var0.random();
        SculkSpreader var5 = SculkSpreader.createWorldGenSpreader();
        int var6 = var3.spreadRounds() + var3.growthRounds();
        for (int var7 = 0; var7 < var6; ++var7) {
            for (var8 = 0; var8 < var3.chargeCount(); var8 += 1) {
                var5.addCursors(var2, var3.amountPerCharge());
            }
            var8 = var7 < var3.spreadRounds() ? 1 : 0;
            for (var9 = 0; var9 < var3.spreadAttempts(); ++var9) {
                var5.updateCursors(var1, var2, var4, var8 != 0);
            }
            var5.clear();
        }
        BlockPosition var7 = var2.below();
        if (var4.nextFloat() <= var3.catalystChance() && var1.getBlockState(var7).isCollisionShapeFullBlock(var1, var7)) {
            var1.setBlock(var2, Blocks.SCULK_CATALYST.defaultBlockState(), 3);
        }
        var8 = var3.extraRareGrowths().sample(var4);
        for (var9 = 0; var9 < var8; ++var9) {
            BlockPosition var10 = var2.offset(var4.nextInt(5) - 2, 0, var4.nextInt(5) - 2);
            if (!var1.getBlockState(var10).isAir() || !var1.getBlockState(var10.below()).isFaceSturdy(var1, var10.below(), EnumDirection.UP)) continue;
            var1.setBlock(var10, (IBlockData)Blocks.SCULK_SHRIEKER.defaultBlockState().setValue(SculkShriekerBlock.CAN_SUMMON, true), 3);
        }
        return true;
    }

    private boolean canSpreadFrom(GeneratorAccess var0, BlockPosition var12) {
        block5: {
            block4: {
                IBlockData var2 = var0.getBlockState(var12);
                if (var2.getBlock() instanceof SculkBehaviour) {
                    return true;
                }
                if (var2.isAir()) break block4;
                if (!var2.is(Blocks.WATER) || !var2.getFluidState().isSource()) break block5;
            }
            return EnumDirection.stream().map(var12::relative).anyMatch(var1 -> var0.getBlockState((BlockPosition)var1).isCollisionShapeFullBlock(var0, (BlockPosition)var1));
        }
        return false;
    }
}

