/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blockpredicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;

public class WouldSurvivePredicate
implements BlockPredicate {
    public static final Codec<WouldSurvivePredicate> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BaseBlockPosition.offsetCodec(16).optionalFieldOf("offset", (Object)BaseBlockPosition.ZERO).forGetter(var0 -> var0.offset), (App)IBlockData.CODEC.fieldOf("state").forGetter(var0 -> var0.state)).apply((Applicative)var02, WouldSurvivePredicate::new));
    private final BaseBlockPosition offset;
    private final IBlockData state;

    protected WouldSurvivePredicate(BaseBlockPosition var0, IBlockData var1) {
        this.offset = var0;
        this.state = var1;
    }

    @Override
    public boolean test(GeneratorAccessSeed var0, BlockPosition var1) {
        return this.state.canSurvive(var0, var1.offset(this.offset));
    }

    @Override
    public BlockPredicateType<?> type() {
        return BlockPredicateType.WOULD_SURVIVE;
    }

    @Override
    public /* synthetic */ boolean test(Object object, Object object2) {
        return this.test((GeneratorAccessSeed)object, (BlockPosition)object2);
    }
}

