/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.slf4j.Logger;

public class EntityLookup<T extends EntityAccess> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Int2ObjectMap<T> byId = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, T> byUuid = Maps.newHashMap();

    public <U extends T> void getEntities(EntityTypeTest<T, U> var0, Consumer<U> var1) {
        for (EntityAccess var3 : this.byId.values()) {
            EntityAccess var4 = (EntityAccess)var0.tryCast(var3);
            if (var4 == null) continue;
            var1.accept(var4);
        }
    }

    public Iterable<T> getAllEntities() {
        return Iterables.unmodifiableIterable((Iterable)this.byId.values());
    }

    public void add(T var0) {
        UUID var1 = var0.getUUID();
        if (this.byUuid.containsKey(var1)) {
            LOGGER.warn("Duplicate entity UUID {}: {}", (Object)var1, var0);
            return;
        }
        this.byUuid.put(var1, var0);
        this.byId.put(var0.getId(), var0);
    }

    public void remove(T var0) {
        this.byUuid.remove(var0.getUUID());
        this.byId.remove(var0.getId());
    }

    @Nullable
    public T getEntity(int var0) {
        return (T)((EntityAccess)this.byId.get(var0));
    }

    @Nullable
    public T getEntity(UUID var0) {
        return (T)((EntityAccess)this.byUuid.get(var0));
    }

    public int count() {
        return this.byUuid.size();
    }
}

