/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossBattle;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class EnderDragonBattle {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_DRAGON_RESPAWN = 1200;
    private static final int TIME_BETWEEN_CRYSTAL_SCANS = 100;
    private static final int TIME_BETWEEN_PLAYER_SCANS = 20;
    private static final int ARENA_SIZE_CHUNKS = 8;
    public static final int ARENA_TICKET_LEVEL = 9;
    private static final int GATEWAY_COUNT = 20;
    private static final int GATEWAY_DISTANCE = 96;
    public static final int DRAGON_SPAWN_Y = 128;
    private static final Predicate<Entity> VALID_PLAYER = IEntitySelector.ENTITY_STILL_ALIVE.and(IEntitySelector.withinDistance(0.0, 128.0, 0.0, 192.0));
    public final BossBattleServer dragonEvent = (BossBattleServer)new BossBattleServer(IChatBaseComponent.translatable("entity.minecraft.ender_dragon"), BossBattle.BarColor.PINK, BossBattle.BarStyle.PROGRESS).setPlayBossMusic(true).setCreateWorldFog(true);
    public final WorldServer level;
    private final ObjectArrayList<Integer> gateways = new ObjectArrayList();
    private final ShapeDetector exitPortalPattern;
    private int ticksSinceDragonSeen;
    private int crystalsAlive;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan;
    private boolean dragonKilled;
    private boolean previouslyKilled;
    @Nullable
    public UUID dragonUUID;
    private boolean needsStateScanning = true;
    @Nullable
    public BlockPosition portalLocation;
    @Nullable
    public EnumDragonRespawn respawnStage;
    private int respawnTime;
    @Nullable
    private List<EntityEnderCrystal> respawnCrystals;

    public EnderDragonBattle(WorldServer var0, long var1, NBTTagCompound var3) {
        this.level = var0;
        if (var3.contains("NeedsStateScanning")) {
            this.needsStateScanning = var3.getBoolean("NeedsStateScanning");
        }
        if (var3.contains("DragonKilled", 99)) {
            if (var3.hasUUID("Dragon")) {
                this.dragonUUID = var3.getUUID("Dragon");
            }
            this.dragonKilled = var3.getBoolean("DragonKilled");
            this.previouslyKilled = var3.getBoolean("PreviouslyKilled");
            if (var3.getBoolean("IsRespawning")) {
                this.respawnStage = EnumDragonRespawn.START;
            }
            if (var3.contains("ExitPortalLocation", 10)) {
                this.portalLocation = GameProfileSerializer.readBlockPos(var3.getCompound("ExitPortalLocation"));
            }
        } else {
            this.dragonKilled = true;
            this.previouslyKilled = true;
        }
        if (var3.contains("Gateways", 9)) {
            NBTTagList var4 = var3.getList("Gateways", 3);
            for (int var5 = 0; var5 < var4.size(); ++var5) {
                this.gateways.add((Object)var4.getInt(var5));
            }
        } else {
            this.gateways.addAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            SystemUtils.shuffle(this.gateways, RandomSource.create(var1));
        }
        this.exitPortalPattern = ShapeDetectorBuilder.start().aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").aisle("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").where('#', ShapeDetectorBlock.hasState(BlockPredicate.forBlock(Blocks.BEDROCK))).build();
    }

    public NBTTagCompound saveData() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.putBoolean("NeedsStateScanning", this.needsStateScanning);
        if (this.dragonUUID != null) {
            var0.putUUID("Dragon", this.dragonUUID);
        }
        var0.putBoolean("DragonKilled", this.dragonKilled);
        var0.putBoolean("PreviouslyKilled", this.previouslyKilled);
        if (this.portalLocation != null) {
            var0.put("ExitPortalLocation", GameProfileSerializer.writeBlockPos(this.portalLocation));
        }
        NBTTagList var1 = new NBTTagList();
        ObjectListIterator objectListIterator = this.gateways.iterator();
        while (objectListIterator.hasNext()) {
            int var3 = (Integer)objectListIterator.next();
            var1.add(NBTTagInt.valueOf(var3));
        }
        var0.put("Gateways", var1);
        return var0;
    }

    public void tick() {
        this.dragonEvent.setVisible(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.dragonEvent.getPlayers().isEmpty()) {
            this.level.getChunkSource().addRegionTicket(TicketType.DRAGON, new ChunkCoordIntPair(0, 0), 9, Unit.INSTANCE);
            boolean var0 = this.isArenaLoaded();
            if (this.needsStateScanning && var0) {
                this.scanState();
                this.needsStateScanning = false;
            }
            if (this.respawnStage != null) {
                if (this.respawnCrystals == null && var0) {
                    this.respawnStage = null;
                    this.tryRespawn();
                }
                this.respawnStage.tick(this.level, this, this.respawnCrystals, this.respawnTime++, this.portalLocation);
            }
            if (!this.dragonKilled) {
                if ((this.dragonUUID == null || ++this.ticksSinceDragonSeen >= 1200) && var0) {
                    this.findOrCreateDragon();
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && var0) {
                    this.updateCrystalCount();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            this.level.getChunkSource().removeRegionTicket(TicketType.DRAGON, new ChunkCoordIntPair(0, 0), 9, Unit.INSTANCE);
        }
    }

    private void scanState() {
        LOGGER.info("Scanning for legacy world dragon fight...");
        boolean var0 = this.hasActiveExitPortal();
        if (var0) {
            LOGGER.info("Found that the dragon has been killed in this world already.");
            this.previouslyKilled = true;
        } else {
            LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.previouslyKilled = false;
            if (this.findExitPortal() == null) {
                this.spawnExitPortal(false);
            }
        }
        List<? extends EntityEnderDragon> var1 = this.level.getDragons();
        if (var1.isEmpty()) {
            this.dragonKilled = true;
        } else {
            EntityEnderDragon var2 = var1.get(0);
            this.dragonUUID = var2.getUUID();
            LOGGER.info("Found that there's a dragon still alive ({})", (Object)var2);
            this.dragonKilled = false;
            if (!var0) {
                LOGGER.info("But we didn't have a portal, let's remove it.");
                var2.discard();
                this.dragonUUID = null;
            }
        }
        if (!this.previouslyKilled && this.dragonKilled) {
            this.dragonKilled = false;
        }
    }

    private void findOrCreateDragon() {
        List<? extends EntityEnderDragon> var0 = this.level.getDragons();
        if (var0.isEmpty()) {
            LOGGER.debug("Haven't seen the dragon, respawning it");
            this.createNewDragon();
        } else {
            LOGGER.debug("Haven't seen our dragon, but found another one to use.");
            this.dragonUUID = var0.get(0).getUUID();
        }
    }

    public void setRespawnStage(EnumDragonRespawn var0) {
        if (this.respawnStage == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnTime = 0;
        if (var0 == EnumDragonRespawn.END) {
            this.respawnStage = null;
            this.dragonKilled = false;
            EntityEnderDragon var1 = this.createNewDragon();
            for (EntityPlayer var3 : this.dragonEvent.getPlayers()) {
                CriterionTriggers.SUMMONED_ENTITY.trigger(var3, var1);
            }
        } else {
            this.respawnStage = var0;
        }
    }

    private boolean hasActiveExitPortal() {
        for (int var0 = -8; var0 <= 8; ++var0) {
            for (int var1 = -8; var1 <= 8; ++var1) {
                Chunk var2 = this.level.getChunk(var0, var1);
                for (TileEntity var4 : var2.getBlockEntities().values()) {
                    if (!(var4 instanceof TileEntityEnderPortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public ShapeDetector.ShapeDetectorCollection findExitPortal() {
        Object var2;
        int var1;
        int var0;
        for (var0 = -8; var0 <= 8; ++var0) {
            for (var1 = -8; var1 <= 8; ++var1) {
                var2 = this.level.getChunk(var0, var1);
                for (TileEntity var4 : ((Chunk)var2).getBlockEntities().values()) {
                    ShapeDetector.ShapeDetectorCollection var5;
                    if (!(var4 instanceof TileEntityEnderPortal) || (var5 = this.exitPortalPattern.find(this.level, var4.getBlockPos())) == null) continue;
                    BlockPosition var6 = var5.getBlock(3, 3, 3).getPos();
                    if (this.portalLocation == null) {
                        this.portalLocation = var6;
                    }
                    return var5;
                }
            }
        }
        for (var1 = var0 = this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, WorldGenEndTrophy.END_PODIUM_LOCATION).getY(); var1 >= this.level.getMinBuildHeight(); --var1) {
            var2 = this.exitPortalPattern.find(this.level, new BlockPosition(WorldGenEndTrophy.END_PODIUM_LOCATION.getX(), var1, WorldGenEndTrophy.END_PODIUM_LOCATION.getZ()));
            if (var2 == null) continue;
            if (this.portalLocation == null) {
                this.portalLocation = ((ShapeDetector.ShapeDetectorCollection)var2).getBlock(3, 3, 3).getPos();
            }
            return var2;
        }
        return null;
    }

    private boolean isArenaLoaded() {
        for (int var0 = -8; var0 <= 8; ++var0) {
            for (int var1 = 8; var1 <= 8; ++var1) {
                IChunkAccess var2 = this.level.getChunk(var0, var1, ChunkStatus.FULL, false);
                if (!(var2 instanceof Chunk)) {
                    return false;
                }
                PlayerChunk.State var3 = ((Chunk)var2).getFullStatus();
                if (var3.isOrAfter(PlayerChunk.State.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        HashSet var0 = Sets.newHashSet();
        for (EntityPlayer var2 : this.level.getPlayers(VALID_PLAYER)) {
            this.dragonEvent.addPlayer(var2);
            var0.add(var2);
        }
        HashSet var1 = Sets.newHashSet(this.dragonEvent.getPlayers());
        var1.removeAll(var0);
        for (EntityPlayer var3 : var1) {
            this.dragonEvent.removePlayer(var3);
        }
    }

    private void updateCrystalCount() {
        this.ticksSinceCrystalsScanned = 0;
        this.crystalsAlive = 0;
        for (WorldGenEnder.Spike var1 : WorldGenEnder.getSpikesForLevel(this.level)) {
            this.crystalsAlive += this.level.getEntitiesOfClass(EntityEnderCrystal.class, var1.getTopBoundingBox()).size();
        }
        LOGGER.debug("Found {} end crystals still alive", (Object)this.crystalsAlive);
    }

    public void setDragonKilled(EntityEnderDragon var0) {
        if (var0.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(0.0f);
            this.dragonEvent.setVisible(false);
            this.spawnExitPortal(true);
            this.spawnNewGateway();
            if (!this.previouslyKilled) {
                this.level.setBlockAndUpdate(this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, WorldGenEndTrophy.END_PODIUM_LOCATION), Blocks.DRAGON_EGG.defaultBlockState());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }

    private void spawnNewGateway() {
        if (this.gateways.isEmpty()) {
            return;
        }
        int var0 = (Integer)this.gateways.remove(this.gateways.size() - 1);
        int var1 = MathHelper.floor(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)var0)));
        int var2 = MathHelper.floor(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)var0)));
        this.spawnNewGateway(new BlockPosition(var1, 75, var2));
    }

    private void spawnNewGateway(BlockPosition var0) {
        this.level.levelEvent(3000, var0, 0);
        EndFeatures.END_GATEWAY_DELAYED.value().place(this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), var0);
    }

    public void spawnExitPortal(boolean var0) {
        WorldGenEndTrophy var1 = new WorldGenEndTrophy(var0);
        if (this.portalLocation == null) {
            this.portalLocation = this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.END_PODIUM_LOCATION).below();
            while (this.level.getBlockState(this.portalLocation).is(Blocks.BEDROCK) && this.portalLocation.getY() > this.level.getSeaLevel()) {
                this.portalLocation = this.portalLocation.below();
            }
        }
        var1.place(WorldGenFeatureConfiguration.NONE, this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), this.portalLocation);
    }

    private EntityEnderDragon createNewDragon() {
        this.level.getChunkAt(new BlockPosition(0, 128, 0));
        EntityEnderDragon var0 = EntityTypes.ENDER_DRAGON.create(this.level);
        var0.getPhaseManager().setPhase(DragonControllerPhase.HOLDING_PATTERN);
        var0.moveTo(0.0, 128.0, 0.0, this.level.random.nextFloat() * 360.0f, 0.0f);
        this.level.addFreshEntity(var0);
        this.dragonUUID = var0.getUUID();
        return var0;
    }

    public void updateDragon(EntityEnderDragon var0) {
        if (var0.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(var0.getHealth() / var0.getMaxHealth());
            this.ticksSinceDragonSeen = 0;
            if (var0.hasCustomName()) {
                this.dragonEvent.setName(var0.getDisplayName());
            }
        }
    }

    public int getCrystalsAlive() {
        return this.crystalsAlive;
    }

    public void onCrystalDestroyed(EntityEnderCrystal var0, DamageSource var1) {
        if (this.respawnStage != null && this.respawnCrystals.contains(var0)) {
            LOGGER.debug("Aborting respawn sequence");
            this.respawnStage = null;
            this.respawnTime = 0;
            this.resetSpikeCrystals();
            this.spawnExitPortal(true);
        } else {
            this.updateCrystalCount();
            Entity var2 = this.level.getEntity(this.dragonUUID);
            if (var2 instanceof EntityEnderDragon) {
                ((EntityEnderDragon)var2).onCrystalDestroyed(var0, var0.blockPosition(), var1);
            }
        }
    }

    public boolean hasPreviouslyKilledDragon() {
        return this.previouslyKilled;
    }

    public void tryRespawn() {
        if (this.dragonKilled && this.respawnStage == null) {
            Object var1;
            BlockPosition var0 = this.portalLocation;
            if (var0 == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                var1 = this.findExitPortal();
                if (var1 == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.spawnExitPortal(true);
                } else {
                    LOGGER.debug("Found the exit portal & saved its location for next time.");
                }
                var0 = this.portalLocation;
            }
            var1 = Lists.newArrayList();
            BlockPosition var2 = var0.above(1);
            for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                List<EntityEnderCrystal> var5 = this.level.getEntitiesOfClass(EntityEnderCrystal.class, new AxisAlignedBB(var2.relative(var4, 2)));
                if (var5.isEmpty()) {
                    return;
                }
                var1.addAll(var5);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            this.respawnDragon((List<EntityEnderCrystal>)var1);
        }
    }

    private void respawnDragon(List<EntityEnderCrystal> var0) {
        if (this.dragonKilled && this.respawnStage == null) {
            ShapeDetector.ShapeDetectorCollection var1 = this.findExitPortal();
            while (var1 != null) {
                for (int var2 = 0; var2 < this.exitPortalPattern.getWidth(); ++var2) {
                    for (int var3 = 0; var3 < this.exitPortalPattern.getHeight(); ++var3) {
                        for (int var4 = 0; var4 < this.exitPortalPattern.getDepth(); ++var4) {
                            ShapeDetectorBlock var5 = var1.getBlock(var2, var3, var4);
                            if (!var5.getState().is(Blocks.BEDROCK) && !var5.getState().is(Blocks.END_PORTAL)) continue;
                            this.level.setBlockAndUpdate(var5.getPos(), Blocks.END_STONE.defaultBlockState());
                        }
                    }
                }
                var1 = this.findExitPortal();
            }
            this.respawnStage = EnumDragonRespawn.START;
            this.respawnTime = 0;
            this.spawnExitPortal(false);
            this.respawnCrystals = var0;
        }
    }

    public void resetSpikeCrystals() {
        for (WorldGenEnder.Spike var1 : WorldGenEnder.getSpikesForLevel(this.level)) {
            List<EntityEnderCrystal> var2 = this.level.getEntitiesOfClass(EntityEnderCrystal.class, var1.getTopBoundingBox());
            for (EntityEnderCrystal var4 : var2) {
                var4.setInvulnerable(false);
                var4.setBeamTarget(null);
            }
        }
    }
}

