/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Material;

public final class BlockPropertyInstrument
extends Enum<BlockPropertyInstrument>
implements INamable {
    public static final /* enum */ BlockPropertyInstrument HARP = new BlockPropertyInstrument("harp", SoundEffects.NOTE_BLOCK_HARP);
    public static final /* enum */ BlockPropertyInstrument BASEDRUM = new BlockPropertyInstrument("basedrum", SoundEffects.NOTE_BLOCK_BASEDRUM);
    public static final /* enum */ BlockPropertyInstrument SNARE = new BlockPropertyInstrument("snare", SoundEffects.NOTE_BLOCK_SNARE);
    public static final /* enum */ BlockPropertyInstrument HAT = new BlockPropertyInstrument("hat", SoundEffects.NOTE_BLOCK_HAT);
    public static final /* enum */ BlockPropertyInstrument BASS = new BlockPropertyInstrument("bass", SoundEffects.NOTE_BLOCK_BASS);
    public static final /* enum */ BlockPropertyInstrument FLUTE = new BlockPropertyInstrument("flute", SoundEffects.NOTE_BLOCK_FLUTE);
    public static final /* enum */ BlockPropertyInstrument BELL = new BlockPropertyInstrument("bell", SoundEffects.NOTE_BLOCK_BELL);
    public static final /* enum */ BlockPropertyInstrument GUITAR = new BlockPropertyInstrument("guitar", SoundEffects.NOTE_BLOCK_GUITAR);
    public static final /* enum */ BlockPropertyInstrument CHIME = new BlockPropertyInstrument("chime", SoundEffects.NOTE_BLOCK_CHIME);
    public static final /* enum */ BlockPropertyInstrument XYLOPHONE = new BlockPropertyInstrument("xylophone", SoundEffects.NOTE_BLOCK_XYLOPHONE);
    public static final /* enum */ BlockPropertyInstrument IRON_XYLOPHONE = new BlockPropertyInstrument("iron_xylophone", SoundEffects.NOTE_BLOCK_IRON_XYLOPHONE);
    public static final /* enum */ BlockPropertyInstrument COW_BELL = new BlockPropertyInstrument("cow_bell", SoundEffects.NOTE_BLOCK_COW_BELL);
    public static final /* enum */ BlockPropertyInstrument DIDGERIDOO = new BlockPropertyInstrument("didgeridoo", SoundEffects.NOTE_BLOCK_DIDGERIDOO);
    public static final /* enum */ BlockPropertyInstrument BIT = new BlockPropertyInstrument("bit", SoundEffects.NOTE_BLOCK_BIT);
    public static final /* enum */ BlockPropertyInstrument BANJO = new BlockPropertyInstrument("banjo", SoundEffects.NOTE_BLOCK_BANJO);
    public static final /* enum */ BlockPropertyInstrument PLING = new BlockPropertyInstrument("pling", SoundEffects.NOTE_BLOCK_PLING);
    private final String name;
    private final SoundEffect soundEvent;
    private static final /* synthetic */ BlockPropertyInstrument[] s;

    public static BlockPropertyInstrument[] values() {
        return (BlockPropertyInstrument[])s.clone();
    }

    public static BlockPropertyInstrument valueOf(String var0) {
        return Enum.valueOf(BlockPropertyInstrument.class, var0);
    }

    private BlockPropertyInstrument(String var2, SoundEffect var3) {
        this.name = var2;
        this.soundEvent = var3;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public SoundEffect getSoundEvent() {
        return this.soundEvent;
    }

    public static BlockPropertyInstrument byState(IBlockData var0) {
        if (var0.is(Blocks.CLAY)) {
            return FLUTE;
        }
        if (var0.is(Blocks.GOLD_BLOCK)) {
            return BELL;
        }
        if (var0.is(TagsBlock.WOOL)) {
            return GUITAR;
        }
        if (var0.is(Blocks.PACKED_ICE)) {
            return CHIME;
        }
        if (var0.is(Blocks.BONE_BLOCK)) {
            return XYLOPHONE;
        }
        if (var0.is(Blocks.IRON_BLOCK)) {
            return IRON_XYLOPHONE;
        }
        if (var0.is(Blocks.SOUL_SAND)) {
            return COW_BELL;
        }
        if (var0.is(Blocks.PUMPKIN)) {
            return DIDGERIDOO;
        }
        if (var0.is(Blocks.EMERALD_BLOCK)) {
            return BIT;
        }
        if (var0.is(Blocks.HAY_BLOCK)) {
            return BANJO;
        }
        if (var0.is(Blocks.GLOWSTONE)) {
            return PLING;
        }
        Material var1 = var0.getMaterial();
        if (var1 == Material.STONE) {
            return BASEDRUM;
        }
        if (var1 == Material.SAND) {
            return SNARE;
        }
        if (var1 == Material.GLASS) {
            return HAT;
        }
        if (var1 == Material.WOOD || var1 == Material.NETHER_WOOD) {
            return BASS;
        }
        return HARP;
    }

    private static /* synthetic */ BlockPropertyInstrument[] b() {
        return new BlockPropertyInstrument[]{HARP, BASEDRUM, SNARE, HAT, BASS, FLUTE, BELL, GUITAR, CHIME, XYLOPHONE, IRON_XYLOPHONE, COW_BELL, DIDGERIDOO, BIT, BANJO, PLING};
    }

    static {
        s = BlockPropertyInstrument.b();
    }
}

