/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Clearable;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerLectern;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class TileEntityLectern
extends TileEntity
implements Clearable,
ITileInventory {
    public static final int DATA_PAGE = 0;
    public static final int NUM_DATA = 1;
    public static final int SLOT_BOOK = 0;
    public static final int NUM_SLOTS = 1;
    public final IInventory bookAccess = new IInventory(){

        @Override
        public int getContainerSize() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return TileEntityLectern.this.book.isEmpty();
        }

        @Override
        public ItemStack getItem(int var0) {
            return var0 == 0 ? TileEntityLectern.this.book : ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItem(int var0, int var1) {
            if (var0 == 0) {
                ItemStack var2 = TileEntityLectern.this.book.split(var1);
                if (TileEntityLectern.this.book.isEmpty()) {
                    TileEntityLectern.this.onBookItemRemove();
                }
                return var2;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItemNoUpdate(int var0) {
            if (var0 == 0) {
                ItemStack var1 = TileEntityLectern.this.book;
                TileEntityLectern.this.book = ItemStack.EMPTY;
                TileEntityLectern.this.onBookItemRemove();
                return var1;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public void setItem(int var0, ItemStack var1) {
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public void setChanged() {
            TileEntityLectern.this.setChanged();
        }

        @Override
        public boolean stillValid(EntityHuman var0) {
            if (TileEntityLectern.this.level.getBlockEntity(TileEntityLectern.this.worldPosition) != TileEntityLectern.this) {
                return false;
            }
            if (var0.distanceToSqr((double)TileEntityLectern.this.worldPosition.getX() + 0.5, (double)TileEntityLectern.this.worldPosition.getY() + 0.5, (double)TileEntityLectern.this.worldPosition.getZ() + 0.5) > 64.0) {
                return false;
            }
            return TileEntityLectern.this.hasBook();
        }

        @Override
        public boolean canPlaceItem(int var0, ItemStack var1) {
            return false;
        }

        @Override
        public void clearContent() {
        }
    };
    private final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int var0) {
            return var0 == 0 ? TileEntityLectern.this.page : 0;
        }

        @Override
        public void set(int var0, int var1) {
            if (var0 == 0) {
                TileEntityLectern.this.setPage(var1);
            }
        }

        @Override
        public int getCount() {
            return 1;
        }
    };
    ItemStack book = ItemStack.EMPTY;
    int page;
    private int pageCount;

    public TileEntityLectern(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.LECTERN, var0, var1);
    }

    public ItemStack getBook() {
        return this.book;
    }

    public boolean hasBook() {
        return this.book.is(Items.WRITABLE_BOOK) || this.book.is(Items.WRITTEN_BOOK);
    }

    public void setBook(ItemStack var0) {
        this.setBook(var0, null);
    }

    void onBookItemRemove() {
        this.page = 0;
        this.pageCount = 0;
        BlockLectern.resetBookState(this.getLevel(), this.getBlockPos(), this.getBlockState(), false);
    }

    public void setBook(ItemStack var0, @Nullable EntityHuman var1) {
        this.book = this.resolveBook(var0, var1);
        this.page = 0;
        this.pageCount = ItemWrittenBook.getPageCount(this.book);
        this.setChanged();
    }

    public void setPage(int var0) {
        int var1 = MathHelper.clamp(var0, 0, this.pageCount - 1);
        if (var1 != this.page) {
            this.page = var1;
            this.setChanged();
            BlockLectern.signalPageChange(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getRedstoneSignal() {
        float var0 = this.pageCount > 1 ? (float)this.getPage() / ((float)this.pageCount - 1.0f) : 1.0f;
        return MathHelper.floor(var0 * 14.0f) + (this.hasBook() ? 1 : 0);
    }

    private ItemStack resolveBook(ItemStack var0, @Nullable EntityHuman var1) {
        if (this.level instanceof WorldServer && var0.is(Items.WRITTEN_BOOK)) {
            ItemWrittenBook.resolveBookComponents(var0, this.createCommandSourceStack(var1), var1);
        }
        return var0;
    }

    private CommandListenerWrapper createCommandSourceStack(@Nullable EntityHuman var0) {
        IChatBaseComponent var2;
        String var1;
        if (var0 == null) {
            var1 = "Lectern";
            var2 = IChatBaseComponent.literal("Lectern");
        } else {
            var1 = var0.getName().getString();
            var2 = var0.getDisplayName();
        }
        Vec3D var3 = Vec3D.atCenterOf(this.worldPosition);
        return new CommandListenerWrapper(ICommandListener.NULL, var3, Vec2F.ZERO, (WorldServer)this.level, 2, var1, var2, this.level.getServer(), var0);
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.book = var0.contains("Book", 10) ? this.resolveBook(ItemStack.of(var0.getCompound("Book")), null) : ItemStack.EMPTY;
        this.pageCount = ItemWrittenBook.getPageCount(this.book);
        this.page = MathHelper.clamp(var0.getInt("Page"), 0, this.pageCount - 1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (!this.getBook().isEmpty()) {
            var0.put("Book", this.getBook().save(new NBTTagCompound()));
            var0.putInt("Page", this.page);
        }
    }

    @Override
    public void clearContent() {
        this.setBook(ItemStack.EMPTY);
    }

    @Override
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        return new ContainerLectern(var0, this.bookAccess, this.dataAccess);
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return IChatBaseComponent.translatable("container.lectern");
    }
}

