/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeHolder,
AutoRecipeOutput {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    protected NonNullList<ItemStack> items = NonNullList.withSize(3, ItemStack.EMPTY);
    public int litTime;
    int litDuration;
    public int cookingProgress;
    public int cookingTotalTime;
    protected final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int var0) {
            switch (var0) {
                case 0: {
                    return TileEntityFurnace.this.litTime;
                }
                case 1: {
                    return TileEntityFurnace.this.litDuration;
                }
                case 2: {
                    return TileEntityFurnace.this.cookingProgress;
                }
                case 3: {
                    return TileEntityFurnace.this.cookingTotalTime;
                }
            }
            return 0;
        }

        @Override
        public void set(int var0, int var1) {
            switch (var0) {
                case 0: {
                    TileEntityFurnace.this.litTime = var1;
                    break;
                }
                case 1: {
                    TileEntityFurnace.this.litDuration = var1;
                    break;
                }
                case 2: {
                    TileEntityFurnace.this.cookingProgress = var1;
                    break;
                }
                case 3: {
                    TileEntityFurnace.this.cookingTotalTime = var1;
                    break;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };
    public final Object2IntOpenHashMap<MinecraftKey> recipesUsed = new Object2IntOpenHashMap();
    private final CraftingManager.a<IInventory, ? extends RecipeCooking> quickCheck;

    protected TileEntityFurnace(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2, Recipes<? extends RecipeCooking> var3) {
        super(var0, var1, var2);
        this.quickCheck = CraftingManager.createCheck(var3);
    }

    public static Map<Item, Integer> getFuel() {
        LinkedHashMap var0 = Maps.newLinkedHashMap();
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.LAVA_BUCKET, 20000);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.COAL_BLOCK, 16000);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.BLAZE_ROD, 2400);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.COAL, 1600);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.CHARCOAL, 1600);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.LOGS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.PLANKS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.WOODEN_STAIRS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.WOODEN_SLABS, 150);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.WOODEN_TRAPDOORS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.WOODEN_PRESSURE_PLATES, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.OAK_FENCE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.BIRCH_FENCE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.SPRUCE_FENCE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.JUNGLE_FENCE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.DARK_OAK_FENCE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.ACACIA_FENCE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.MANGROVE_FENCE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.OAK_FENCE_GATE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.BIRCH_FENCE_GATE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.SPRUCE_FENCE_GATE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.JUNGLE_FENCE_GATE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.DARK_OAK_FENCE_GATE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.ACACIA_FENCE_GATE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.MANGROVE_FENCE_GATE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.NOTE_BLOCK, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.BOOKSHELF, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.LECTERN, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.JUKEBOX, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.CHEST, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.TRAPPED_CHEST, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.CRAFTING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.DAYLIGHT_DETECTOR, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.BANNERS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.BOW, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.FISHING_ROD, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.LADDER, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.SIGNS, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.WOODEN_SHOVEL, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.WOODEN_SWORD, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.WOODEN_HOE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.WOODEN_AXE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.WOODEN_PICKAXE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.WOODEN_DOORS, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.BOATS, 1200);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.WOOL, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.WOODEN_BUTTONS, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.STICK, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.SAPLINGS, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.BOWL, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var0, TagsItem.WOOL_CARPETS, 67);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.DRIED_KELP_BLOCK, 4001);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Items.CROSSBOW, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.BAMBOO, 50);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.DEAD_BUSH, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.SCAFFOLDING, 50);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.LOOM, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.BARREL, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.CARTOGRAPHY_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.FLETCHING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.SMITHING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.COMPOSTER, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.AZALEA, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.FLOWERING_AZALEA, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var0, Blocks.MANGROVE_ROOTS, 300);
        return var0;
    }

    private static boolean isNeverAFurnaceFuel(Item var0) {
        return var0.builtInRegistryHolder().is(TagsItem.NON_FLAMMABLE_WOOD);
    }

    private static void add(Map<Item, Integer> var0, TagKey<Item> var1, int var2) {
        for (Holder<Item> var4 : IRegistry.ITEM.getTagOrEmpty(var1)) {
            if (TileEntityFurnace.isNeverAFurnaceFuel(var4.value())) continue;
            var0.put(var4.value(), var2);
        }
    }

    private static void add(Map<Item, Integer> var0, IMaterial var1, int var2) {
        Item var3 = var1.asItem();
        if (TileEntityFurnace.isNeverAFurnaceFuel(var3)) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                throw SystemUtils.pauseInIde(new IllegalStateException("A developer tried to explicitly make fire resistant item " + var3.getName(null).getString() + " a furnace fuel. That will not work!"));
            }
            return;
        }
        var0.put(var3, var2);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerUtil.loadAllItems(var0, this.items);
        this.litTime = var0.getShort("BurnTime");
        this.cookingProgress = var0.getShort("CookTime");
        this.cookingTotalTime = var0.getShort("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.items.get(1));
        NBTTagCompound var1 = var0.getCompound("RecipesUsed");
        for (String var3 : var1.getAllKeys()) {
            this.recipesUsed.put((Object)new MinecraftKey(var3), var1.getInt(var3));
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.putShort("BurnTime", (short)this.litTime);
        var0.putShort("CookTime", (short)this.cookingProgress);
        var0.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        ContainerUtil.saveAllItems(var0, this.items);
        NBTTagCompound var12 = new NBTTagCompound();
        this.recipesUsed.forEach((var1, var2) -> var12.putInt(var1.toString(), (int)var2));
        var0.put("RecipesUsed", var12);
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, TileEntityFurnace var3) {
        boolean var8;
        boolean var4 = var3.isLit();
        boolean var5 = false;
        if (var3.isLit()) {
            --var3.litTime;
        }
        ItemStack var6 = var3.items.get(1);
        boolean var7 = !var3.items.get(0).isEmpty();
        boolean bl = var8 = !var6.isEmpty();
        if (var3.isLit() || var8 && var7) {
            IRecipe var9 = var7 ? (IRecipe)var3.quickCheck.getRecipeFor(var3, var0).orElse(null) : null;
            int var10 = var3.getMaxStackSize();
            if (!var3.isLit() && TileEntityFurnace.canBurn(var9, var3.items, var10)) {
                var3.litDuration = var3.litTime = var3.getBurnDuration(var6);
                if (var3.isLit()) {
                    var5 = true;
                    if (var8) {
                        Item var11 = var6.getItem();
                        var6.shrink(1);
                        if (var6.isEmpty()) {
                            Item var12 = var11.getCraftingRemainingItem();
                            var3.items.set(1, var12 == null ? ItemStack.EMPTY : new ItemStack(var12));
                        }
                    }
                }
            }
            if (var3.isLit() && TileEntityFurnace.canBurn(var9, var3.items, var10)) {
                ++var3.cookingProgress;
                if (var3.cookingProgress == var3.cookingTotalTime) {
                    var3.cookingProgress = 0;
                    var3.cookingTotalTime = TileEntityFurnace.getTotalCookTime(var0, var3);
                    if (TileEntityFurnace.burn(var9, var3.items, var10)) {
                        var3.setRecipeUsed(var9);
                    }
                    var5 = true;
                }
            } else {
                var3.cookingProgress = 0;
            }
        } else if (!var3.isLit() && var3.cookingProgress > 0) {
            var3.cookingProgress = MathHelper.clamp(var3.cookingProgress - 2, 0, var3.cookingTotalTime);
        }
        if (var4 != var3.isLit()) {
            var5 = true;
            var2 = (IBlockData)var2.setValue(BlockFurnace.LIT, var3.isLit());
            var0.setBlock(var1, var2, 3);
        }
        if (var5) {
            TileEntityFurnace.setChanged(var0, var1, var2);
        }
    }

    private static boolean canBurn(@Nullable IRecipe<?> var0, NonNullList<ItemStack> var1, int var2) {
        if (var1.get(0).isEmpty() || var0 == null) {
            return false;
        }
        ItemStack var3 = var0.getResultItem();
        if (var3.isEmpty()) {
            return false;
        }
        ItemStack var4 = var1.get(2);
        if (var4.isEmpty()) {
            return true;
        }
        if (!var4.sameItem(var3)) {
            return false;
        }
        if (var4.getCount() < var2 && var4.getCount() < var4.getMaxStackSize()) {
            return true;
        }
        return var4.getCount() < var3.getMaxStackSize();
    }

    private static boolean burn(@Nullable IRecipe<?> var0, NonNullList<ItemStack> var1, int var2) {
        if (var0 == null || !TileEntityFurnace.canBurn(var0, var1, var2)) {
            return false;
        }
        ItemStack var3 = var1.get(0);
        ItemStack var4 = var0.getResultItem();
        ItemStack var5 = var1.get(2);
        if (var5.isEmpty()) {
            var1.set(2, var4.copy());
        } else if (var5.is(var4.getItem())) {
            var5.grow(1);
        }
        if (var3.is(Blocks.WET_SPONGE.asItem()) && !var1.get(1).isEmpty() && var1.get(1).is(Items.BUCKET)) {
            var1.set(1, new ItemStack(Items.WATER_BUCKET));
        }
        var3.shrink(1);
        return true;
    }

    protected int getBurnDuration(ItemStack var0) {
        if (var0.isEmpty()) {
            return 0;
        }
        Item var1 = var0.getItem();
        return TileEntityFurnace.getFuel().getOrDefault(var1, 0);
    }

    private static int getTotalCookTime(World var0, TileEntityFurnace var1) {
        return var1.quickCheck.getRecipeFor(var1, var0).map(RecipeCooking::getCookingTime).orElse(200);
    }

    public static boolean isFuel(ItemStack var0) {
        return TileEntityFurnace.getFuel().containsKey(var0.getItem());
    }

    @Override
    public int[] getSlotsForFace(EnumDirection var0) {
        if (var0 == EnumDirection.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (var0 == EnumDirection.UP) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int var0, ItemStack var1, @Nullable EnumDirection var2) {
        return this.canPlaceItem(var0, var1);
    }

    @Override
    public boolean canTakeItemThroughFace(int var0, ItemStack var1, EnumDirection var2) {
        if (var2 == EnumDirection.DOWN && var0 == 1) {
            return var1.is(Items.WATER_BUCKET) || var1.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.items) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int var0) {
        return this.items.get(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        return ContainerUtil.removeItem(this.items, var0, var1);
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        return ContainerUtil.takeItem(this.items, var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        ItemStack var2 = this.items.get(var0);
        boolean var3 = !var1.isEmpty() && var1.sameItem(var2) && ItemStack.tagMatches(var1, var2);
        this.items.set(var0, var1);
        if (var1.getCount() > this.getMaxStackSize()) {
            var1.setCount(this.getMaxStackSize());
        }
        if (var0 == 0 && !var3) {
            this.cookingTotalTime = TileEntityFurnace.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return var0.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @Override
    public boolean canPlaceItem(int var0, ItemStack var1) {
        if (var0 == 2) {
            return false;
        }
        if (var0 == 1) {
            ItemStack var2 = this.items.get(1);
            return TileEntityFurnace.isFuel(var1) || var1.is(Items.BUCKET) && !var2.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    @Override
    public void setRecipeUsed(@Nullable IRecipe<?> var0) {
        if (var0 != null) {
            MinecraftKey var1 = var0.getId();
            this.recipesUsed.addTo((Object)var1, 1);
        }
    }

    @Override
    @Nullable
    public IRecipe<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(EntityHuman var0) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer var0) {
        List<IRecipe<?>> var1 = this.getRecipesToAwardAndPopExperience(var0.getLevel(), var0.position());
        var0.awardRecipes(var1);
        this.recipesUsed.clear();
    }

    public List<IRecipe<?>> getRecipesToAwardAndPopExperience(WorldServer var0, Vec3D var1) {
        ArrayList var2 = Lists.newArrayList();
        for (Object2IntMap.Entry var42 : this.recipesUsed.object2IntEntrySet()) {
            var0.getRecipeManager().byKey((MinecraftKey)var42.getKey()).ifPresent(var4 -> {
                var2.add(var4);
                TileEntityFurnace.createExperience(var0, var1, var42.getIntValue(), ((RecipeCooking)var4).getExperience());
            });
        }
        return var2;
    }

    private static void createExperience(WorldServer var0, Vec3D var1, int var2, float var3) {
        int var4 = MathHelper.floor((float)var2 * var3);
        float var5 = MathHelper.frac((float)var2 * var3);
        if (var5 != 0.0f && Math.random() < (double)var5) {
            ++var4;
        }
        EntityExperienceOrb.award(var0, var1, var4);
    }

    @Override
    public void fillStackedContents(AutoRecipeStackManager var0) {
        for (ItemStack var2 : this.items) {
            var0.accountStack(var2);
        }
    }
}

