/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.IBlockData;

public interface WeatheringCopper
extends ChangeOverTimeBlock<a> {
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)Blocks.COPPER_BLOCK, (Object)Blocks.EXPOSED_COPPER).put((Object)Blocks.EXPOSED_COPPER, (Object)Blocks.WEATHERED_COPPER).put((Object)Blocks.WEATHERED_COPPER, (Object)Blocks.OXIDIZED_COPPER).put((Object)Blocks.CUT_COPPER, (Object)Blocks.EXPOSED_CUT_COPPER).put((Object)Blocks.EXPOSED_CUT_COPPER, (Object)Blocks.WEATHERED_CUT_COPPER).put((Object)Blocks.WEATHERED_CUT_COPPER, (Object)Blocks.OXIDIZED_CUT_COPPER).put((Object)Blocks.CUT_COPPER_SLAB, (Object)Blocks.EXPOSED_CUT_COPPER_SLAB).put((Object)Blocks.EXPOSED_CUT_COPPER_SLAB, (Object)Blocks.WEATHERED_CUT_COPPER_SLAB).put((Object)Blocks.WEATHERED_CUT_COPPER_SLAB, (Object)Blocks.OXIDIZED_CUT_COPPER_SLAB).put((Object)Blocks.CUT_COPPER_STAIRS, (Object)Blocks.EXPOSED_CUT_COPPER_STAIRS).put((Object)Blocks.EXPOSED_CUT_COPPER_STAIRS, (Object)Blocks.WEATHERED_CUT_COPPER_STAIRS).put((Object)Blocks.WEATHERED_CUT_COPPER_STAIRS, (Object)Blocks.OXIDIZED_CUT_COPPER_STAIRS).build());
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());

    public static Optional<Block> getPrevious(Block var0) {
        return Optional.ofNullable((Block)PREVIOUS_BY_BLOCK.get().get((Object)var0));
    }

    public static Block getFirst(Block var0) {
        Block var1 = var0;
        Block var2 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)var1);
        while (var2 != null) {
            var1 = var2;
            var2 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)var1);
        }
        return var1;
    }

    public static Optional<IBlockData> getPrevious(IBlockData var0) {
        return WeatheringCopper.getPrevious(var0.getBlock()).map(var1 -> var1.withPropertiesOf(var0));
    }

    public static Optional<Block> getNext(Block var0) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)var0));
    }

    public static IBlockData getFirst(IBlockData var0) {
        return WeatheringCopper.getFirst(var0.getBlock()).withPropertiesOf(var0);
    }

    @Override
    default public Optional<IBlockData> getNext(IBlockData var0) {
        return WeatheringCopper.getNext(var0.getBlock()).map(var1 -> var1.withPropertiesOf(var0));
    }

    @Override
    default public float getChanceModifier() {
        if (this.getAge() == a.UNAFFECTED) {
            return 0.75f;
        }
        return 1.0f;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a UNAFFECTED = new a();
        public static final /* enum */ a EXPOSED = new a();
        public static final /* enum */ a WEATHERED = new a();
        public static final /* enum */ a OXIDIZED = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{UNAFFECTED, EXPOSED, WEATHERED, OXIDIZED};
        }

        static {
            e = a.a();
        }
    }
}

