/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class TallSeagrassBlock
extends BlockTallPlant
implements IFluidContainer {
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> HALF = BlockTallPlant.HALF;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    public TallSeagrassBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.isFaceSturdy(var1, var2, EnumDirection.UP) && !var0.is(Blocks.MAGMA_BLOCK);
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(Blocks.SEAGRASS);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var2;
        IBlockData var1 = super.getStateForPlacement(var0);
        if (var1 != null && (var2 = var0.getLevel().getFluidState(var0.getClickedPos().above())).is(TagsFluid.WATER) && var2.getAmount() == 8) {
            return var1;
        }
        return null;
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        if (var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.UPPER) {
            IBlockData var3 = var1.getBlockState(var2.below());
            return var3.is(this) && var3.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER;
        }
        Fluid var3 = var1.getFluidState(var2);
        return super.canSurvive(var0, var1, var2) && var3.is(TagsFluid.WATER) && var3.getAmount() == 8;
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        return FluidTypes.WATER.getSource(false);
    }

    @Override
    public boolean canPlaceLiquid(IBlockAccess var0, BlockPosition var1, IBlockData var2, FluidType var3) {
        return false;
    }

    @Override
    public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        return false;
    }
}

