/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class SculkSensorBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final int ACTIVE_TICKS = 40;
    public static final int COOLDOWN_TICKS = 1;
    public static final Object2IntMap<GameEvent> VIBRATION_FREQUENCY_FOR_EVENT = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)SystemUtils.make(new Object2IntOpenHashMap(), var0 -> {
        var0.put((Object)GameEvent.STEP, 1);
        var0.put((Object)GameEvent.FLAP, 2);
        var0.put((Object)GameEvent.SWIM, 3);
        var0.put((Object)GameEvent.ELYTRA_GLIDE, 4);
        var0.put((Object)GameEvent.HIT_GROUND, 5);
        var0.put((Object)GameEvent.TELEPORT, 5);
        var0.put((Object)GameEvent.SPLASH, 6);
        var0.put((Object)GameEvent.ENTITY_SHAKE, 6);
        var0.put((Object)GameEvent.BLOCK_CHANGE, 6);
        var0.put((Object)GameEvent.NOTE_BLOCK_PLAY, 6);
        var0.put((Object)GameEvent.PROJECTILE_SHOOT, 7);
        var0.put((Object)GameEvent.DRINK, 7);
        var0.put((Object)GameEvent.PRIME_FUSE, 7);
        var0.put((Object)GameEvent.PROJECTILE_LAND, 8);
        var0.put((Object)GameEvent.EAT, 8);
        var0.put((Object)GameEvent.ENTITY_INTERACT, 8);
        var0.put((Object)GameEvent.ENTITY_DAMAGE, 8);
        var0.put((Object)GameEvent.EQUIP, 9);
        var0.put((Object)GameEvent.SHEAR, 9);
        var0.put((Object)GameEvent.ENTITY_ROAR, 9);
        var0.put((Object)GameEvent.BLOCK_CLOSE, 10);
        var0.put((Object)GameEvent.BLOCK_DEACTIVATE, 10);
        var0.put((Object)GameEvent.BLOCK_DETACH, 10);
        var0.put((Object)GameEvent.DISPENSE_FAIL, 10);
        var0.put((Object)GameEvent.BLOCK_OPEN, 11);
        var0.put((Object)GameEvent.BLOCK_ACTIVATE, 11);
        var0.put((Object)GameEvent.BLOCK_ATTACH, 11);
        var0.put((Object)GameEvent.ENTITY_PLACE, 12);
        var0.put((Object)GameEvent.BLOCK_PLACE, 12);
        var0.put((Object)GameEvent.FLUID_PLACE, 12);
        var0.put((Object)GameEvent.ENTITY_DIE, 13);
        var0.put((Object)GameEvent.BLOCK_DESTROY, 13);
        var0.put((Object)GameEvent.FLUID_PICKUP, 13);
        var0.put((Object)GameEvent.ITEM_INTERACT_FINISH, 14);
        var0.put((Object)GameEvent.CONTAINER_CLOSE, 14);
        var0.put((Object)GameEvent.PISTON_CONTRACT, 14);
        var0.put((Object)GameEvent.PISTON_EXTEND, 15);
        var0.put((Object)GameEvent.CONTAINER_OPEN, 15);
        var0.put((Object)GameEvent.ITEM_INTERACT_START, 15);
        var0.put((Object)GameEvent.EXPLODE, 15);
        var0.put((Object)GameEvent.LIGHTNING_STRIKE, 15);
        var0.put((Object)GameEvent.INSTRUMENT_PLAY, 15);
    })));
    public static final BlockStateEnum<SculkSensorPhase> PHASE = BlockProperties.SCULK_SENSOR_PHASE;
    public static final BlockStateInteger POWER = BlockProperties.POWER;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private final int listenerRange;

    public SculkSensorBlock(BlockBase.Info var0, int var1) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(PHASE, SculkSensorPhase.INACTIVE)).setValue(POWER, 0)).setValue(WATERLOGGED, false));
        this.listenerRange = var1;
    }

    public int getListenerRange() {
        return this.listenerRange;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        Fluid var2 = var0.getLevel().getFluidState(var1);
        return (IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var2.getType() == FluidTypes.WATER);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (SculkSensorBlock.getPhase(var0) != SculkSensorPhase.ACTIVE) {
            if (SculkSensorBlock.getPhase(var0) == SculkSensorPhase.COOLDOWN) {
                var1.setBlock(var2, (IBlockData)var0.setValue(PHASE, SculkSensorPhase.INACTIVE), 3);
            }
            return;
        }
        SculkSensorBlock.deactivate(var1, var2, var0);
    }

    @Override
    public void stepOn(World var0, BlockPosition var1, IBlockData var2, Entity var3) {
        if (!var0.isClientSide() && SculkSensorBlock.canActivate(var2) && var3.getType() != EntityTypes.WARDEN) {
            TileEntity var4 = var0.getBlockEntity(var1);
            if (var4 instanceof SculkSensorBlockEntity) {
                SculkSensorBlockEntity var5 = (SculkSensorBlockEntity)var4;
                var5.setLastVibrationFrequency(VIBRATION_FREQUENCY_FOR_EVENT.get((Object)GameEvent.STEP));
            }
            SculkSensorBlock.activate(var3, var0, var1, var2, 15);
        }
        super.stepOn(var0, var1, var2, var3);
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var1.isClientSide() || var0.is(var3.getBlock())) {
            return;
        }
        if (var0.getValue(POWER) > 0 && !var1.getBlockTicks().hasScheduledTick(var2, this)) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWER, 0), 18);
        }
        var1.scheduleTick(new BlockPosition(var2), var0.getBlock(), 1);
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        if (SculkSensorBlock.getPhase(var0) == SculkSensorPhase.ACTIVE) {
            SculkSensorBlock.updateNeighbours(var1, var2);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    private static void updateNeighbours(World var0, BlockPosition var1) {
        var0.updateNeighborsAt(var1, Blocks.SCULK_SENSOR);
        var0.updateNeighborsAt(var1.relative(EnumDirection.UP.getOpposite()), Blocks.SCULK_SENSOR);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new SculkSensorBlockEntity(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> GameEventListener getListener(WorldServer var0, T var1) {
        if (var1 instanceof SculkSensorBlockEntity) {
            return ((SculkSensorBlockEntity)var1).getListener();
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var02, IBlockData var12, TileEntityTypes<T> var22) {
        if (!var02.isClientSide) {
            return SculkSensorBlock.createTickerHelper(var22, TileEntityTypes.SCULK_SENSOR, (var0, var1, var2, var3) -> var3.getListener().tick(var0));
        }
        return null;
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWER);
    }

    public static SculkSensorPhase getPhase(IBlockData var0) {
        return var0.getValue(PHASE);
    }

    public static boolean canActivate(IBlockData var0) {
        return SculkSensorBlock.getPhase(var0) == SculkSensorPhase.INACTIVE;
    }

    public static void deactivate(World var0, BlockPosition var1, IBlockData var2) {
        var0.setBlock(var1, (IBlockData)((IBlockData)var2.setValue(PHASE, SculkSensorPhase.COOLDOWN)).setValue(POWER, 0), 3);
        var0.scheduleTick(var1, var2.getBlock(), 1);
        if (!var2.getValue(WATERLOGGED).booleanValue()) {
            var0.playSound(null, var1, SoundEffects.SCULK_CLICKING_STOP, SoundCategory.BLOCKS, 1.0f, var0.random.nextFloat() * 0.2f + 0.8f);
        }
        SculkSensorBlock.updateNeighbours(var0, var1);
    }

    public static void activate(@Nullable Entity var0, World var1, BlockPosition var2, IBlockData var3, int var4) {
        var1.setBlock(var2, (IBlockData)((IBlockData)var3.setValue(PHASE, SculkSensorPhase.ACTIVE)).setValue(POWER, var4), 3);
        var1.scheduleTick(var2, var3.getBlock(), 40);
        SculkSensorBlock.updateNeighbours(var1, var2);
        var1.gameEvent(var0, GameEvent.SCULK_SENSOR_TENDRILS_CLICKING, var2);
        if (!var3.getValue(WATERLOGGED).booleanValue()) {
            var1.playSound(null, (double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, SoundEffects.SCULK_CLICKING, SoundCategory.BLOCKS, 1.0f, var1.random.nextFloat() * 0.2f + 0.8f);
        }
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (SculkSensorBlock.getPhase(var0) != SculkSensorPhase.ACTIVE) {
            return;
        }
        EnumDirection var4 = EnumDirection.getRandom(var3);
        if (var4 == EnumDirection.UP || var4 == EnumDirection.DOWN) {
            return;
        }
        double var5 = (double)var2.getX() + 0.5 + (var4.getStepX() == 0 ? 0.5 - var3.nextDouble() : (double)var4.getStepX() * 0.6);
        double var7 = (double)var2.getY() + 0.25;
        double var9 = (double)var2.getZ() + 0.5 + (var4.getStepZ() == 0 ? 0.5 - var3.nextDouble() : (double)var4.getStepZ() * 0.6);
        double var11 = (double)var3.nextFloat() * 0.04;
        var1.addParticle(DustColorTransitionOptions.SCULK_TO_REDSTONE, var5, var7, var9, 0.0, var11, 0.0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(PHASE, POWER, WATERLOGGED);
    }

    @Override
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        TileEntity var3 = var1.getBlockEntity(var2);
        if (var3 instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity var4 = (SculkSensorBlockEntity)var3;
            return SculkSensorBlock.getPhase(var0) == SculkSensorPhase.ACTIVE ? var4.getLastVibrationFrequency() : 0;
        }
        return 0;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    public void spawnAfterBreak(IBlockData var0, WorldServer var1, BlockPosition var2, ItemStack var3, boolean var4) {
        super.spawnAfterBreak(var0, var1, var2, var3, var4);
        if (var4) {
            this.tryDropExperience(var1, var2, var3, ConstantInt.of(5));
        }
    }
}

