/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class CaveVinesBlock
extends BlockGrowingTop
implements IBlockFragilePlantElement,
CaveVines {
    private static final float CHANCE_OF_BERRIES_ON_GROWTH = 0.11f;

    public CaveVinesBlock(BlockBase.Info var0) {
        super(var0, EnumDirection.DOWN, SHAPE, false, 0.1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0)).setValue(BERRIES, false));
    }

    @Override
    protected int getBlocksToGrowWhenBonemealed(RandomSource var0) {
        return 1;
    }

    @Override
    protected boolean canGrowInto(IBlockData var0) {
        return var0.isAir();
    }

    @Override
    protected Block getBodyBlock() {
        return Blocks.CAVE_VINES_PLANT;
    }

    @Override
    protected IBlockData updateBodyAfterConvertedFromHead(IBlockData var0, IBlockData var1) {
        return (IBlockData)var1.setValue(BERRIES, var0.getValue(BERRIES));
    }

    @Override
    protected IBlockData getGrowIntoState(IBlockData var0, RandomSource var1) {
        return (IBlockData)super.getGrowIntoState(var0, var1).setValue(BERRIES, var1.nextFloat() < 0.11f);
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(Items.GLOW_BERRIES);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        return CaveVines.use(var0, var1, var2);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        super.createBlockStateDefinition(var0);
        var0.add(BERRIES);
    }

    @Override
    public boolean isValidBonemealTarget(IBlockAccess var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return var2.getValue(BERRIES) == false;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        var0.setBlock(var2, (IBlockData)var3.setValue(BERRIES, true), 2);
    }
}

