/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.predicate.MaterialPredicate;
import net.minecraft.world.level.material.Material;

public class BlockWitherSkull
extends BlockSkull {
    @Nullable
    private static ShapeDetector witherPatternFull;
    @Nullable
    private static ShapeDetector witherPatternBase;

    protected BlockWitherSkull(BlockBase.Info var0) {
        super(BlockSkull.Type.WITHER_SKELETON, var0);
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        TileEntity var5 = var0.getBlockEntity(var1);
        if (var5 instanceof TileEntitySkull) {
            BlockWitherSkull.checkSpawn(var0, var1, (TileEntitySkull)var5);
        }
    }

    public static void checkSpawn(World var0, BlockPosition var1, TileEntitySkull var2) {
        boolean var4;
        if (var0.isClientSide) {
            return;
        }
        IBlockData var3 = var2.getBlockState();
        boolean bl = var4 = var3.is(Blocks.WITHER_SKELETON_SKULL) || var3.is(Blocks.WITHER_SKELETON_WALL_SKULL);
        if (!var4 || var1.getY() < var0.getMinBuildHeight() || var0.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return;
        }
        ShapeDetector var5 = BlockWitherSkull.getOrCreateWitherFull();
        ShapeDetector.ShapeDetectorCollection var6 = var5.find(var0, var1);
        if (var6 == null) {
            return;
        }
        for (int var7 = 0; var7 < var5.getWidth(); ++var7) {
            for (int var8 = 0; var8 < var5.getHeight(); ++var8) {
                ShapeDetectorBlock var9 = var6.getBlock(var7, var8, 0);
                var0.setBlock(var9.getPos(), Blocks.AIR.defaultBlockState(), 2);
                var0.levelEvent(2001, var9.getPos(), Block.getId(var9.getState()));
            }
        }
        EntityWither var7 = EntityTypes.WITHER.create(var0);
        BlockPosition var8 = var6.getBlock(1, 2, 0).getPos();
        var7.moveTo((double)var8.getX() + 0.5, (double)var8.getY() + 0.55, (double)var8.getZ() + 0.5, var6.getForwards().getAxis() == EnumDirection.EnumAxis.X ? 0.0f : 90.0f, 0.0f);
        var7.yBodyRot = var6.getForwards().getAxis() == EnumDirection.EnumAxis.X ? 0.0f : 90.0f;
        var7.makeInvulnerable();
        for (EntityPlayer var10 : var0.getEntitiesOfClass(EntityPlayer.class, var7.getBoundingBox().inflate(50.0))) {
            CriterionTriggers.SUMMONED_ENTITY.trigger(var10, var7);
        }
        var0.addFreshEntity(var7);
        for (int var9 = 0; var9 < var5.getWidth(); ++var9) {
            for (int var10 = 0; var10 < var5.getHeight(); ++var10) {
                var0.blockUpdated(var6.getBlock(var9, var10, 0).getPos(), Blocks.AIR);
            }
        }
    }

    public static boolean canSpawnMob(World var0, BlockPosition var1, ItemStack var2) {
        if (var2.is(Items.WITHER_SKELETON_SKULL) && var1.getY() >= var0.getMinBuildHeight() + 2 && var0.getDifficulty() != EnumDifficulty.PEACEFUL && !var0.isClientSide) {
            return BlockWitherSkull.getOrCreateWitherBase().find(var0, var1) != null;
        }
        return false;
    }

    private static ShapeDetector getOrCreateWitherFull() {
        if (witherPatternFull == null) {
            witherPatternFull = ShapeDetectorBuilder.start().aisle("^^^", "###", "~#~").where('#', var0 -> var0.getState().is(TagsBlock.WITHER_SUMMON_BASE_BLOCKS)).where('^', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_SKULL).or(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_WALL_SKULL)))).where('~', ShapeDetectorBlock.hasState(MaterialPredicate.forMaterial(Material.AIR))).build();
        }
        return witherPatternFull;
    }

    private static ShapeDetector getOrCreateWitherBase() {
        if (witherPatternBase == null) {
            witherPatternBase = ShapeDetectorBuilder.start().aisle("   ", "###", "~#~").where('#', var0 -> var0.getState().is(TagsBlock.WITHER_SUMMON_BASE_BLOCKS)).where('~', ShapeDetectorBlock.hasState(MaterialPredicate.forMaterial(Material.AIR))).build();
        }
        return witherPatternBase;
    }
}

