/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;

public class BlockCoral
extends Block {
    private final Block deadBlock;

    public BlockCoral(Block var0, BlockBase.Info var1) {
        super(var1);
        this.deadBlock = var0;
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!this.scanForWater(var1, var2)) {
            var1.setBlock(var2, this.deadBlock.defaultBlockState(), 2);
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!this.scanForWater(var3, var4)) {
            var3.scheduleTick(var4, this, 60 + var3.getRandom().nextInt(40));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    protected boolean scanForWater(IBlockAccess var0, BlockPosition var1) {
        for (EnumDirection var5 : EnumDirection.values()) {
            Fluid var6 = var0.getFluidState(var1.relative(var5));
            if (!var6.is(TagsFluid.WATER)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        if (!this.scanForWater(var0.getLevel(), var0.getClickedPos())) {
            var0.getLevel().scheduleTick(var0.getClickedPos(), this, 60 + var0.getLevel().getRandom().nextInt(40));
        }
        return this.defaultBlockState();
    }
}

