/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.DensityFunction;

public class WorldChunkManagerTheEnd
extends WorldChunkManager {
    public static final Codec<WorldChunkManagerTheEnd> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)RegistryOps.retrieveRegistry(IRegistry.BIOME_REGISTRY).forGetter(var0 -> null)).apply((Applicative)var02, var02.stable(WorldChunkManagerTheEnd::new)));
    private final Holder<BiomeBase> end;
    private final Holder<BiomeBase> highlands;
    private final Holder<BiomeBase> midlands;
    private final Holder<BiomeBase> islands;
    private final Holder<BiomeBase> barrens;

    public WorldChunkManagerTheEnd(IRegistry<BiomeBase> var0) {
        this(var0.getOrCreateHolderOrThrow(Biomes.THE_END), var0.getOrCreateHolderOrThrow(Biomes.END_HIGHLANDS), var0.getOrCreateHolderOrThrow(Biomes.END_MIDLANDS), var0.getOrCreateHolderOrThrow(Biomes.SMALL_END_ISLANDS), var0.getOrCreateHolderOrThrow(Biomes.END_BARRENS));
    }

    private WorldChunkManagerTheEnd(Holder<BiomeBase> var0, Holder<BiomeBase> var1, Holder<BiomeBase> var2, Holder<BiomeBase> var3, Holder<BiomeBase> var4) {
        super((List<Holder<BiomeBase>>)ImmutableList.of(var0, var1, var2, var3, var4));
        this.end = var0;
        this.highlands = var1;
        this.midlands = var2;
        this.islands = var3;
        this.barrens = var4;
    }

    @Override
    protected Codec<? extends WorldChunkManager> codec() {
        return CODEC;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        int var8;
        int var4 = QuartPos.toBlock(var0);
        int var5 = QuartPos.toBlock(var1);
        int var6 = QuartPos.toBlock(var2);
        int var7 = SectionPosition.blockToSectionCoord(var4);
        if ((long)var7 * (long)var7 + (long)(var8 = SectionPosition.blockToSectionCoord(var6)) * (long)var8 <= 4096L) {
            return this.end;
        }
        int var9 = (SectionPosition.blockToSectionCoord(var4) * 2 + 1) * 8;
        int var10 = (SectionPosition.blockToSectionCoord(var6) * 2 + 1) * 8;
        double var11 = var3.erosion().compute(new DensityFunction.e(var9, var5, var10));
        if (var11 > 0.25) {
            return this.highlands;
        }
        if (var11 >= -0.0625) {
            return this.midlands;
        }
        if (var11 < -0.21875) {
            return this.islands;
        }
        return this.barrens;
    }
}

