/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.EntityMinecartContainer;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityMinecartHopper
extends EntityMinecartContainer
implements IHopper {
    public static final int MOVE_ITEM_SPEED = 4;
    private boolean enabled = true;
    private int cooldownTime = -1;
    private final BlockPosition lastPosition = BlockPosition.ZERO;

    public EntityMinecartHopper(EntityTypes<? extends EntityMinecartHopper> var0, World var1) {
        super(var0, var1);
    }

    public EntityMinecartHopper(World var0, double var1, double var3, double var5) {
        super(EntityTypes.HOPPER_MINECART, var1, var3, var5, var0);
    }

    @Override
    public EntityMinecartAbstract.EnumMinecartType getMinecartType() {
        return EntityMinecartAbstract.EnumMinecartType.HOPPER;
    }

    @Override
    public IBlockData getDefaultDisplayBlockState() {
        return Blocks.HOPPER.defaultBlockState();
    }

    @Override
    public int getDefaultDisplayOffset() {
        return 1;
    }

    @Override
    public int getContainerSize() {
        return 5;
    }

    @Override
    public void activateMinecart(int var0, int var1, int var2, boolean var3) {
        boolean var4;
        boolean bl = var4 = !var3;
        if (var4 != this.isEnabled()) {
            this.setEnabled(var4);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean var0) {
        this.enabled = var0;
    }

    @Override
    public double getLevelX() {
        return this.getX();
    }

    @Override
    public double getLevelY() {
        return this.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return this.getZ();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide && this.isAlive() && this.isEnabled()) {
            BlockPosition var0 = this.blockPosition();
            if (var0.equals(this.lastPosition)) {
                --this.cooldownTime;
            } else {
                this.setCooldown(0);
            }
            if (!this.isOnCooldown()) {
                this.setCooldown(0);
                if (this.suckInItems()) {
                    this.setCooldown(4);
                    this.setChanged();
                }
            }
        }
    }

    public boolean suckInItems() {
        if (TileEntityHopper.suckInItems(this.level, this)) {
            return true;
        }
        List<Entity> var0 = this.level.getEntitiesOfClass(EntityItem.class, this.getBoundingBox().inflate(0.25, 0.0, 0.25), IEntitySelector.ENTITY_STILL_ALIVE);
        if (!var0.isEmpty()) {
            TileEntityHopper.addItem(this, (EntityItem)var0.get(0));
        }
        return false;
    }

    @Override
    protected Item getDropItem() {
        return Items.HOPPER_MINECART;
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("TransferCooldown", this.cooldownTime);
        var0.putBoolean("Enabled", this.enabled);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.cooldownTime = var0.getInt("TransferCooldown");
        this.enabled = var0.contains("Enabled") ? var0.getBoolean("Enabled") : true;
    }

    public void setCooldown(int var0) {
        this.cooldownTime = var0;
    }

    public boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    @Override
    public Container createMenu(int var0, PlayerInventory var1) {
        return new ContainerHopper(var0, var1, this);
    }
}

