/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityProjectile
extends IProjectile {
    protected EntityProjectile(EntityTypes<? extends EntityProjectile> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    protected EntityProjectile(EntityTypes<? extends EntityProjectile> var0, double var1, double var3, double var5, World var7) {
        this(var0, var7);
        this.setPos(var1, var3, var5);
    }

    protected EntityProjectile(EntityTypes<? extends EntityProjectile> var0, EntityLiving var1, World var2) {
        this(var0, var1.getX(), var1.getEyeY() - (double)0.1f, var1.getZ(), var2);
        this.setOwner(var1);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2)) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    @Override
    public void tick() {
        float var9;
        Object var2;
        super.tick();
        MovingObjectPosition var0 = ProjectileHelper.getHitResult(this, this::canHitEntity);
        boolean var1 = false;
        if (var0.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            var2 = ((MovingObjectPositionBlock)var0).getBlockPos();
            IBlockData var3 = this.level.getBlockState((BlockPosition)var2);
            if (var3.is(Blocks.NETHER_PORTAL)) {
                this.handleInsidePortal((BlockPosition)var2);
                var1 = true;
            } else if (var3.is(Blocks.END_GATEWAY)) {
                TileEntity var4 = this.level.getBlockEntity((BlockPosition)var2);
                if (var4 instanceof TileEntityEndGateway && TileEntityEndGateway.canEntityTeleport(this)) {
                    TileEntityEndGateway.teleportEntity(this.level, (BlockPosition)var2, var3, this, (TileEntityEndGateway)var4);
                }
                var1 = true;
            }
        }
        if (var0.getType() != MovingObjectPosition.EnumMovingObjectType.MISS && !var1) {
            this.onHit(var0);
        }
        this.checkInsideBlocks();
        var2 = this.getDeltaMovement();
        double var3 = this.getX() + ((Vec3D)var2).x;
        double var5 = this.getY() + ((Vec3D)var2).y;
        double var7 = this.getZ() + ((Vec3D)var2).z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int var10 = 0; var10 < 4; ++var10) {
                float var11 = 0.25f;
                this.level.addParticle(Particles.BUBBLE, var3 - ((Vec3D)var2).x * 0.25, var5 - ((Vec3D)var2).y * 0.25, var7 - ((Vec3D)var2).z * 0.25, ((Vec3D)var2).x, ((Vec3D)var2).y, ((Vec3D)var2).z);
            }
            var9 = 0.8f;
        } else {
            var9 = 0.99f;
        }
        this.setDeltaMovement(((Vec3D)var2).scale(var9));
        if (!this.isNoGravity()) {
            Vec3D var10 = this.getDeltaMovement();
            this.setDeltaMovement(var10.x, var10.y - (double)this.getGravity(), var10.z);
        }
        this.setPos(var3, var5, var7);
    }

    protected float getGravity() {
        return 0.03f;
    }
}

