/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> DATA_BABY_ID = DataWatcher.defineId(EntityPiglin.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_IS_CHARGING_CROSSBOW = DataWatcher.defineId(EntityPiglin.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_IS_DANCING = DataWatcher.defineId(EntityPiglin.class, DataWatcherRegistry.BOOLEAN);
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("766bfa64-11f3-11ea-8d71-362b9e155667");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", (double)0.2f, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final int MAX_HEALTH = 16;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.35f;
    private static final int ATTACK_DAMAGE = 5;
    private static final float CROSSBOW_POWER = 1.6f;
    private static final float CHANCE_OF_WEARING_EACH_ARMOUR_ITEM = 0.1f;
    private static final int MAX_PASSENGERS_ON_ONE_HOGLIN = 3;
    private static final float PROBABILITY_OF_SPAWNING_AS_BABY = 0.2f;
    private static final float BABY_EYE_HEIGHT_ADJUSTMENT = 0.81f;
    private static final double PROBABILITY_OF_SPAWNING_WITH_CROSSBOW_INSTEAD_OF_SWORD = 0.5;
    public final InventorySubcontainer inventory = new InventorySubcontainer(8);
    public boolean cannotHunt;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ITEMS, SensorType.HURT_BY, SensorType.PIGLIN_SPECIFIC_SENSOR);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.DOORS_TO_CLOSE, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, MemoryModuleType.NEARBY_ADULT_PIGLINS, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.WALK_TARGET, (Object[])new MemoryModuleType[]{MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.PATH, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.ADMIRING_ITEM, MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, MemoryModuleType.ADMIRING_DISABLED, MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, MemoryModuleType.CELEBRATE_LOCATION, MemoryModuleType.DANCING, MemoryModuleType.HUNTED_RECENTLY, MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.RIDE_TARGET, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, MemoryModuleType.ATE_RECENTLY, MemoryModuleType.NEAREST_REPELLENT});

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> var0, World var1) {
        super(var0, var1);
        this.xpReward = 5;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.isBaby()) {
            var0.putBoolean("IsBaby", true);
        }
        if (this.cannotHunt) {
            var0.putBoolean("CannotHunt", true);
        }
        var0.put("Inventory", this.inventory.createTag());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setBaby(var0.getBoolean("IsBaby"));
        this.setCannotHunt(var0.getBoolean("CannotHunt"));
        this.inventory.fromTag(var0.getList("Inventory", 10));
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer getInventory() {
        return this.inventory;
    }

    @Override
    protected void dropCustomDeathLoot(DamageSource var0, int var1, boolean var2) {
        super.dropCustomDeathLoot(var0, var1, var2);
        this.inventory.removeAllItems().forEach(this::spawnAtLocation);
    }

    protected ItemStack addToInventory(ItemStack var0) {
        return this.inventory.addItem(var0);
    }

    protected boolean canAddToInventory(ItemStack var0) {
        return this.inventory.canAddItem(var0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_BABY_ID, false);
        this.entityData.define(DATA_IS_CHARGING_CROSSBOW, false);
        this.entityData.define(DATA_IS_DANCING, false);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_BABY_ID.equals(var0)) {
            this.refreshDimensions();
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 16.0).add(GenericAttributes.MOVEMENT_SPEED, 0.35f).add(GenericAttributes.ATTACK_DAMAGE, 5.0);
    }

    public static boolean checkPiglinSpawnRules(EntityTypes<EntityPiglin> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return !var1.getBlockState(var3.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        RandomSource var5 = var0.getRandom();
        if (var2 != EnumMobSpawn.STRUCTURE) {
            if (var5.nextFloat() < 0.2f) {
                this.setBaby(true);
            } else if (this.isAdult()) {
                this.setItemSlot(EnumItemSlot.MAINHAND, this.createSpawnWeapon());
            }
        }
        PiglinAI.initMemories(this, var0.getRandom());
        this.populateDefaultEquipmentSlots(var5, var1);
        this.populateDefaultEquipmentEnchantments(var5, var1);
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.isPersistenceRequired();
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        if (this.isAdult()) {
            this.maybeWearArmor(EnumItemSlot.HEAD, new ItemStack(Items.GOLDEN_HELMET), var0);
            this.maybeWearArmor(EnumItemSlot.CHEST, new ItemStack(Items.GOLDEN_CHESTPLATE), var0);
            this.maybeWearArmor(EnumItemSlot.LEGS, new ItemStack(Items.GOLDEN_LEGGINGS), var0);
            this.maybeWearArmor(EnumItemSlot.FEET, new ItemStack(Items.GOLDEN_BOOTS), var0);
        }
    }

    private void maybeWearArmor(EnumItemSlot var0, ItemStack var1, RandomSource var2) {
        if (var2.nextFloat() < 0.1f) {
            this.setItemSlot(var0, var1);
        }
    }

    protected BehaviorController.b<EntityPiglin> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return PiglinAI.makeBrain(this, this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<EntityPiglin> getBrain() {
        return super.getBrain();
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        EnumInteractionResult var2 = super.mobInteract(var0, var1);
        if (var2.consumesAction()) {
            return var2;
        }
        if (this.level.isClientSide) {
            boolean var3 = PiglinAI.canAdmire(this, var0.getItemInHand(var1)) && this.getArmPose() != EntityPiglinArmPose.ADMIRING_ITEM;
            return var3 ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
        }
        return PiglinAI.mobInteract(this, var0, var1);
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return this.isBaby() ? 0.93f : 1.74f;
    }

    @Override
    public double getPassengersRidingOffset() {
        return (double)this.getBbHeight() * 0.92;
    }

    @Override
    public void setBaby(boolean var0) {
        this.getEntityData().set(DATA_BABY_ID, var0);
        if (!this.level.isClientSide) {
            AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            var1.removeModifier(SPEED_MODIFIER_BABY);
            if (var0) {
                var1.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    @Override
    public boolean isBaby() {
        return this.getEntityData().get(DATA_BABY_ID);
    }

    private void setCannotHunt(boolean var0) {
        this.cannotHunt = var0;
    }

    @Override
    protected boolean canHunt() {
        return !this.cannotHunt;
    }

    @Override
    protected void customServerAiStep() {
        this.level.getProfiler().push("piglinBrain");
        this.getBrain().tick((WorldServer)this.level, this);
        this.level.getProfiler().pop();
        PiglinAI.updateActivity(this);
        super.customServerAiStep();
    }

    @Override
    public int getExperienceReward() {
        return this.xpReward;
    }

    @Override
    protected void finishConversion(WorldServer var0) {
        PiglinAI.cancelAdmiring(this);
        this.inventory.removeAllItems().forEach(this::spawnAtLocation);
        super.finishConversion(var0);
    }

    private ItemStack createSpawnWeapon() {
        if ((double)this.random.nextFloat() < 0.5) {
            return new ItemStack(Items.CROSSBOW);
        }
        return new ItemStack(Items.GOLDEN_SWORD);
    }

    private boolean isChargingCrossbow() {
        return this.entityData.get(DATA_IS_CHARGING_CROSSBOW);
    }

    @Override
    public void setChargingCrossbow(boolean var0) {
        this.entityData.set(DATA_IS_CHARGING_CROSSBOW, var0);
    }

    @Override
    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    @Override
    public EntityPiglinArmPose getArmPose() {
        if (this.isDancing()) {
            return EntityPiglinArmPose.DANCING;
        }
        if (PiglinAI.isLovedItem(this.getOffhandItem())) {
            return EntityPiglinArmPose.ADMIRING_ITEM;
        }
        if (this.isAggressive() && this.isHoldingMeleeWeapon()) {
            return EntityPiglinArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.isChargingCrossbow()) {
            return EntityPiglinArmPose.CROSSBOW_CHARGE;
        }
        if (this.isAggressive() && this.isHolding(Items.CROSSBOW)) {
            return EntityPiglinArmPose.CROSSBOW_HOLD;
        }
        return EntityPiglinArmPose.DEFAULT;
    }

    public boolean isDancing() {
        return this.entityData.get(DATA_IS_DANCING);
    }

    public void setDancing(boolean var0) {
        this.entityData.set(DATA_IS_DANCING, var0);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        boolean var2 = super.hurt(var0, var1);
        if (this.level.isClientSide) {
            return false;
        }
        if (var2 && var0.getEntity() instanceof EntityLiving) {
            PiglinAI.wasHurtBy(this, (EntityLiving)var0.getEntity());
        }
        return var2;
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        this.performCrossbowAttack(this, 1.6f);
    }

    @Override
    public void shootCrossbowProjectile(EntityLiving var0, ItemStack var1, IProjectile var2, float var3) {
        this.shootCrossbowProjectile(this, var0, var2, var3, 1.6f);
    }

    @Override
    public boolean canFireProjectileWeapon(ItemProjectileWeapon var0) {
        return var0 == Items.CROSSBOW;
    }

    protected void holdInMainHand(ItemStack var0) {
        this.setItemSlotAndDropWhenKilled(EnumItemSlot.MAINHAND, var0);
    }

    protected void holdInOffHand(ItemStack var0) {
        if (var0.is(PiglinAI.BARTERING_ITEM)) {
            this.setItemSlot(EnumItemSlot.OFFHAND, var0);
            this.setGuaranteedDrop(EnumItemSlot.OFFHAND);
        } else {
            this.setItemSlotAndDropWhenKilled(EnumItemSlot.OFFHAND, var0);
        }
    }

    @Override
    public boolean wantsToPickUp(ItemStack var0) {
        return this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && this.canPickUpLoot() && PiglinAI.wantsToPickup(this, var0);
    }

    protected boolean canReplaceCurrentItem(ItemStack var0) {
        EnumItemSlot var1 = EntityInsentient.getEquipmentSlotForItem(var0);
        ItemStack var2 = this.getItemBySlot(var1);
        return this.canReplaceCurrentItem(var0, var2);
    }

    @Override
    protected boolean canReplaceCurrentItem(ItemStack var0, ItemStack var1) {
        boolean var3;
        if (EnchantmentManager.hasBindingCurse(var1)) {
            return false;
        }
        boolean var2 = PiglinAI.isLovedItem(var0) || var0.is(Items.CROSSBOW);
        boolean bl = var3 = PiglinAI.isLovedItem(var1) || var1.is(Items.CROSSBOW);
        if (var2 && !var3) {
            return true;
        }
        if (!var2 && var3) {
            return false;
        }
        if (this.isAdult() && !var0.is(Items.CROSSBOW) && var1.is(Items.CROSSBOW)) {
            return false;
        }
        return super.canReplaceCurrentItem(var0, var1);
    }

    @Override
    protected void pickUpItem(EntityItem var0) {
        this.onItemPickup(var0);
        PiglinAI.pickUpItem(this, var0);
    }

    @Override
    public boolean startRiding(Entity var0, boolean var1) {
        if (this.isBaby() && var0.getType() == EntityTypes.HOGLIN) {
            var0 = this.getTopPassenger(var0, 3);
        }
        return super.startRiding(var0, var1);
    }

    private Entity getTopPassenger(Entity var0, int var1) {
        List<Entity> var2 = var0.getPassengers();
        if (var1 == 1 || var2.isEmpty()) {
            return var0;
        }
        return this.getTopPassenger(var2.get(0), var1 - 1);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.level.isClientSide) {
            return null;
        }
        return PiglinAI.getSoundForCurrentActivity(this).orElse(null);
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PIGLIN_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PIGLIN_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.PIGLIN_STEP, 0.15f, 1.0f);
    }

    protected void playSoundEvent(SoundEffect var0) {
        this.playSound(var0, this.getSoundVolume(), this.getVoicePitch());
    }

    @Override
    protected void playConvertedSound() {
        this.playSoundEvent(SoundEffects.PIGLIN_CONVERTED_TO_ZOMBIFIED);
    }
}

